package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait DomainHealth {
  def unwrap: software.amazon.awssdk.services.opensearch.model.DomainHealth
}
object DomainHealth {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.DomainHealth
  ): zio.aws.opensearch.model.DomainHealth = value match {
    case software.amazon.awssdk.services.opensearch.model.DomainHealth.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.DomainHealth.RED =>
      val r = Red
      r
    case software.amazon.awssdk.services.opensearch.model.DomainHealth.YELLOW =>
      val r = Yellow
      r
    case software.amazon.awssdk.services.opensearch.model.DomainHealth.GREEN =>
      val r = Green
      r
    case software.amazon.awssdk.services.opensearch.model.DomainHealth.NOT_AVAILABLE =>
      val r = NotAvailable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.DomainHealth {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainHealth =
      software.amazon.awssdk.services.opensearch.model.DomainHealth.UNKNOWN_TO_SDK_VERSION
  }
  case object Red extends zio.aws.opensearch.model.DomainHealth {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainHealth =
      software.amazon.awssdk.services.opensearch.model.DomainHealth.RED
  }
  case object Yellow extends zio.aws.opensearch.model.DomainHealth {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainHealth =
      software.amazon.awssdk.services.opensearch.model.DomainHealth.YELLOW
  }
  case object Green extends zio.aws.opensearch.model.DomainHealth {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainHealth =
      software.amazon.awssdk.services.opensearch.model.DomainHealth.GREEN
  }
  case object NotAvailable extends zio.aws.opensearch.model.DomainHealth {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainHealth =
      software.amazon.awssdk.services.opensearch.model.DomainHealth.NOT_AVAILABLE
  }
}
