package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DomainEndpointOptionsStatus(
    options: zio.aws.opensearch.model.DomainEndpointOptions,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DomainEndpointOptionsStatus = {
    import DomainEndpointOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DomainEndpointOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DomainEndpointOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.DomainEndpointOptionsStatus.wrap(buildAwsValue())
}
object DomainEndpointOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DomainEndpointOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DomainEndpointOptionsStatus =
      zio.aws.opensearch.model
        .DomainEndpointOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DomainEndpointOptionsStatus
  ) extends zio.aws.opensearch.model.DomainEndpointOptionsStatus.ReadOnly {
    override val options
        : zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly =
      zio.aws.opensearch.model.DomainEndpointOptions.wrap(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DomainEndpointOptionsStatus
  ): zio.aws.opensearch.model.DomainEndpointOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
