package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.VpcEndpointId
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointsRequest(
    vpcEndpointIds: Iterable[VpcEndpointId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest = {
    import DescribeVpcEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest
      .builder()
      .vpcEndpointIds(vpcEndpointIds.map { item =>
        VpcEndpointId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeVpcEndpointsRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeVpcEndpointsRequest.wrap(buildAwsValue())
}
object DescribeVpcEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeVpcEndpointsRequest =
      zio.aws.opensearch.model.DescribeVpcEndpointsRequest(vpcEndpointIds)
    def vpcEndpointIds: List[VpcEndpointId]
    def getVpcEndpointIds: ZIO[Any, Nothing, List[VpcEndpointId]] =
      ZIO.succeed(vpcEndpointIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest
  ) extends zio.aws.opensearch.model.DescribeVpcEndpointsRequest.ReadOnly {
    override val vpcEndpointIds: List[VpcEndpointId] = impl
      .vpcEndpointIds()
      .asScala
      .map { item =>
        zio.aws.opensearch.model.primitives.VpcEndpointId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest
  ): zio.aws.opensearch.model.DescribeVpcEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
