package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDryRunProgressResponse(
    dryRunProgressStatus: Optional[
      zio.aws.opensearch.model.DryRunProgressStatus
    ] = Optional.Absent,
    dryRunConfig: Optional[zio.aws.opensearch.model.DomainStatus] =
      Optional.Absent,
    dryRunResults: Optional[zio.aws.opensearch.model.DryRunResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressResponse = {
    import DescribeDryRunProgressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressResponse
      .builder()
      .optionallyWith(dryRunProgressStatus.map(value => value.buildAwsValue()))(
        _.dryRunProgressStatus
      )
      .optionallyWith(dryRunConfig.map(value => value.buildAwsValue()))(
        _.dryRunConfig
      )
      .optionallyWith(dryRunResults.map(value => value.buildAwsValue()))(
        _.dryRunResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDryRunProgressResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeDryRunProgressResponse
      .wrap(buildAwsValue())
}
object DescribeDryRunProgressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDryRunProgressResponse =
      zio.aws.opensearch.model.DescribeDryRunProgressResponse(
        dryRunProgressStatus.map(value => value.asEditable),
        dryRunConfig.map(value => value.asEditable),
        dryRunResults.map(value => value.asEditable)
      )
    def dryRunProgressStatus
        : Optional[zio.aws.opensearch.model.DryRunProgressStatus.ReadOnly]
    def dryRunConfig: Optional[zio.aws.opensearch.model.DomainStatus.ReadOnly]
    def dryRunResults: Optional[zio.aws.opensearch.model.DryRunResults.ReadOnly]
    def getDryRunProgressStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DryRunProgressStatus.ReadOnly
    ] = AwsError.unwrapOptionField("dryRunProgressStatus", dryRunProgressStatus)
    def getDryRunConfig
        : ZIO[Any, AwsError, zio.aws.opensearch.model.DomainStatus.ReadOnly] =
      AwsError.unwrapOptionField("dryRunConfig", dryRunConfig)
    def getDryRunResults
        : ZIO[Any, AwsError, zio.aws.opensearch.model.DryRunResults.ReadOnly] =
      AwsError.unwrapOptionField("dryRunResults", dryRunResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressResponse
  ) extends zio.aws.opensearch.model.DescribeDryRunProgressResponse.ReadOnly {
    override val dryRunProgressStatus
        : Optional[zio.aws.opensearch.model.DryRunProgressStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dryRunProgressStatus())
        .map(value => zio.aws.opensearch.model.DryRunProgressStatus.wrap(value))
    override val dryRunConfig
        : Optional[zio.aws.opensearch.model.DomainStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dryRunConfig())
        .map(value => zio.aws.opensearch.model.DomainStatus.wrap(value))
    override val dryRunResults
        : Optional[zio.aws.opensearch.model.DryRunResults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dryRunResults())
        .map(value => zio.aws.opensearch.model.DryRunResults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressResponse
  ): zio.aws.opensearch.model.DescribeDryRunProgressResponse.ReadOnly =
    new Wrapper(impl)
}
