package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{GUID, DomainName}
import scala.jdk.CollectionConverters._
final case class DescribeDryRunProgressRequest(
    domainName: DomainName,
    dryRunId: Optional[GUID] = Optional.Absent,
    loadDryRunConfig: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest = {
    import DescribeDryRunProgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        dryRunId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.dryRunId)
      .optionallyWith(loadDryRunConfig.map(value => value: java.lang.Boolean))(
        _.loadDryRunConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDryRunProgressRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeDryRunProgressRequest.wrap(buildAwsValue())
}
object DescribeDryRunProgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDryRunProgressRequest =
      zio.aws.opensearch.model.DescribeDryRunProgressRequest(
        domainName,
        dryRunId.map(value => value),
        loadDryRunConfig.map(value => value)
      )
    def domainName: DomainName
    def dryRunId: Optional[GUID]
    def loadDryRunConfig: Optional[Boolean]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getDryRunId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("dryRunId", dryRunId)
    def getLoadDryRunConfig: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("loadDryRunConfig", loadDryRunConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest
  ) extends zio.aws.opensearch.model.DescribeDryRunProgressRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val dryRunId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRunId())
      .map(value => zio.aws.opensearch.model.primitives.GUID(value))
    override val loadDryRunConfig: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.loadDryRunConfig())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest
  ): zio.aws.opensearch.model.DescribeDryRunProgressRequest.ReadOnly =
    new Wrapper(impl)
}
