package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDomainNodesResponse(
    domainNodesStatusList: Optional[
      Iterable[zio.aws.opensearch.model.DomainNodesStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesResponse = {
    import DescribeDomainNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesResponse
      .builder()
      .optionallyWith(
        domainNodesStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNodesStatusList)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDomainNodesResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainNodesResponse.wrap(buildAwsValue())
}
object DescribeDomainNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainNodesResponse =
      zio.aws.opensearch.model.DescribeDomainNodesResponse(
        domainNodesStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainNodesStatusList
        : Optional[List[zio.aws.opensearch.model.DomainNodesStatus.ReadOnly]]
    def getDomainNodesStatusList: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.DomainNodesStatus.ReadOnly
    ]] =
      AwsError.unwrapOptionField("domainNodesStatusList", domainNodesStatusList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesResponse
  ) extends zio.aws.opensearch.model.DescribeDomainNodesResponse.ReadOnly {
    override val domainNodesStatusList
        : Optional[List[zio.aws.opensearch.model.DomainNodesStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNodesStatusList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.DomainNodesStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesResponse
  ): zio.aws.opensearch.model.DescribeDomainNodesResponse.ReadOnly =
    new Wrapper(impl)
}
