package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class DescribeDomainNodesRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest = {
    import DescribeDomainNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DescribeDomainNodesRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainNodesRequest.wrap(buildAwsValue())
}
object DescribeDomainNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainNodesRequest =
      zio.aws.opensearch.model.DescribeDomainNodesRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest
  ) extends zio.aws.opensearch.model.DescribeDomainNodesRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest
  ): zio.aws.opensearch.model.DescribeDomainNodesRequest.ReadOnly = new Wrapper(
    impl
  )
}
