package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{
  NumberOfShards,
  NumberOfNodes,
  NumberOfAZs
}
import scala.jdk.CollectionConverters._
final case class DescribeDomainHealthResponse(
    domainState: Optional[zio.aws.opensearch.model.DomainState] =
      Optional.Absent,
    availabilityZoneCount: Optional[NumberOfAZs] = Optional.Absent,
    activeAvailabilityZoneCount: Optional[NumberOfAZs] = Optional.Absent,
    standByAvailabilityZoneCount: Optional[NumberOfAZs] = Optional.Absent,
    dataNodeCount: Optional[NumberOfNodes] = Optional.Absent,
    dedicatedMaster: Optional[Boolean] = Optional.Absent,
    masterEligibleNodeCount: Optional[NumberOfNodes] = Optional.Absent,
    warmNodeCount: Optional[NumberOfNodes] = Optional.Absent,
    masterNode: Optional[zio.aws.opensearch.model.MasterNodeStatus] =
      Optional.Absent,
    clusterHealth: Optional[zio.aws.opensearch.model.DomainHealth] =
      Optional.Absent,
    totalShards: Optional[NumberOfShards] = Optional.Absent,
    totalUnAssignedShards: Optional[NumberOfShards] = Optional.Absent,
    environmentInformation: Optional[
      Iterable[zio.aws.opensearch.model.EnvironmentInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthResponse = {
    import DescribeDomainHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthResponse
      .builder()
      .optionallyWith(domainState.map(value => value.unwrap))(_.domainState)
      .optionallyWith(
        availabilityZoneCount.map(value =>
          NumberOfAZs.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneCount)
      .optionallyWith(
        activeAvailabilityZoneCount.map(value =>
          NumberOfAZs.unwrap(value): java.lang.String
        )
      )(_.activeAvailabilityZoneCount)
      .optionallyWith(
        standByAvailabilityZoneCount.map(value =>
          NumberOfAZs.unwrap(value): java.lang.String
        )
      )(_.standByAvailabilityZoneCount)
      .optionallyWith(
        dataNodeCount.map(value =>
          NumberOfNodes.unwrap(value): java.lang.String
        )
      )(_.dataNodeCount)
      .optionallyWith(dedicatedMaster.map(value => value: java.lang.Boolean))(
        _.dedicatedMaster
      )
      .optionallyWith(
        masterEligibleNodeCount.map(value =>
          NumberOfNodes.unwrap(value): java.lang.String
        )
      )(_.masterEligibleNodeCount)
      .optionallyWith(
        warmNodeCount.map(value =>
          NumberOfNodes.unwrap(value): java.lang.String
        )
      )(_.warmNodeCount)
      .optionallyWith(masterNode.map(value => value.unwrap))(_.masterNode)
      .optionallyWith(clusterHealth.map(value => value.unwrap))(_.clusterHealth)
      .optionallyWith(
        totalShards.map(value => NumberOfShards.unwrap(value): java.lang.String)
      )(_.totalShards)
      .optionallyWith(
        totalUnAssignedShards.map(value =>
          NumberOfShards.unwrap(value): java.lang.String
        )
      )(_.totalUnAssignedShards)
      .optionallyWith(
        environmentInformation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentInformation)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDomainHealthResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainHealthResponse.wrap(buildAwsValue())
}
object DescribeDomainHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainHealthResponse =
      zio.aws.opensearch.model.DescribeDomainHealthResponse(
        domainState.map(value => value),
        availabilityZoneCount.map(value => value),
        activeAvailabilityZoneCount.map(value => value),
        standByAvailabilityZoneCount.map(value => value),
        dataNodeCount.map(value => value),
        dedicatedMaster.map(value => value),
        masterEligibleNodeCount.map(value => value),
        warmNodeCount.map(value => value),
        masterNode.map(value => value),
        clusterHealth.map(value => value),
        totalShards.map(value => value),
        totalUnAssignedShards.map(value => value),
        environmentInformation.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainState: Optional[zio.aws.opensearch.model.DomainState]
    def availabilityZoneCount: Optional[NumberOfAZs]
    def activeAvailabilityZoneCount: Optional[NumberOfAZs]
    def standByAvailabilityZoneCount: Optional[NumberOfAZs]
    def dataNodeCount: Optional[NumberOfNodes]
    def dedicatedMaster: Optional[Boolean]
    def masterEligibleNodeCount: Optional[NumberOfNodes]
    def warmNodeCount: Optional[NumberOfNodes]
    def masterNode: Optional[zio.aws.opensearch.model.MasterNodeStatus]
    def clusterHealth: Optional[zio.aws.opensearch.model.DomainHealth]
    def totalShards: Optional[NumberOfShards]
    def totalUnAssignedShards: Optional[NumberOfShards]
    def environmentInformation
        : Optional[List[zio.aws.opensearch.model.EnvironmentInfo.ReadOnly]]
    def getDomainState
        : ZIO[Any, AwsError, zio.aws.opensearch.model.DomainState] =
      AwsError.unwrapOptionField("domainState", domainState)
    def getAvailabilityZoneCount: ZIO[Any, AwsError, NumberOfAZs] =
      AwsError.unwrapOptionField("availabilityZoneCount", availabilityZoneCount)
    def getActiveAvailabilityZoneCount: ZIO[Any, AwsError, NumberOfAZs] =
      AwsError.unwrapOptionField(
        "activeAvailabilityZoneCount",
        activeAvailabilityZoneCount
      )
    def getStandByAvailabilityZoneCount: ZIO[Any, AwsError, NumberOfAZs] =
      AwsError.unwrapOptionField(
        "standByAvailabilityZoneCount",
        standByAvailabilityZoneCount
      )
    def getDataNodeCount: ZIO[Any, AwsError, NumberOfNodes] =
      AwsError.unwrapOptionField("dataNodeCount", dataNodeCount)
    def getDedicatedMaster: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dedicatedMaster", dedicatedMaster)
    def getMasterEligibleNodeCount: ZIO[Any, AwsError, NumberOfNodes] = AwsError
      .unwrapOptionField("masterEligibleNodeCount", masterEligibleNodeCount)
    def getWarmNodeCount: ZIO[Any, AwsError, NumberOfNodes] =
      AwsError.unwrapOptionField("warmNodeCount", warmNodeCount)
    def getMasterNode
        : ZIO[Any, AwsError, zio.aws.opensearch.model.MasterNodeStatus] =
      AwsError.unwrapOptionField("masterNode", masterNode)
    def getClusterHealth
        : ZIO[Any, AwsError, zio.aws.opensearch.model.DomainHealth] =
      AwsError.unwrapOptionField("clusterHealth", clusterHealth)
    def getTotalShards: ZIO[Any, AwsError, NumberOfShards] =
      AwsError.unwrapOptionField("totalShards", totalShards)
    def getTotalUnAssignedShards: ZIO[Any, AwsError, NumberOfShards] =
      AwsError.unwrapOptionField("totalUnAssignedShards", totalUnAssignedShards)
    def getEnvironmentInformation: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.EnvironmentInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "environmentInformation",
      environmentInformation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthResponse
  ) extends zio.aws.opensearch.model.DescribeDomainHealthResponse.ReadOnly {
    override val domainState: Optional[zio.aws.opensearch.model.DomainState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainState())
        .map(value => zio.aws.opensearch.model.DomainState.wrap(value))
    override val availabilityZoneCount: Optional[NumberOfAZs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneCount())
        .map(value => zio.aws.opensearch.model.primitives.NumberOfAZs(value))
    override val activeAvailabilityZoneCount: Optional[NumberOfAZs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeAvailabilityZoneCount())
        .map(value => zio.aws.opensearch.model.primitives.NumberOfAZs(value))
    override val standByAvailabilityZoneCount: Optional[NumberOfAZs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standByAvailabilityZoneCount())
        .map(value => zio.aws.opensearch.model.primitives.NumberOfAZs(value))
    override val dataNodeCount: Optional[NumberOfNodes] = zio.aws.core.internal
      .optionalFromNullable(impl.dataNodeCount())
      .map(value => zio.aws.opensearch.model.primitives.NumberOfNodes(value))
    override val dedicatedMaster: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dedicatedMaster())
      .map(value => value: Boolean)
    override val masterEligibleNodeCount: Optional[NumberOfNodes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterEligibleNodeCount())
        .map(value => zio.aws.opensearch.model.primitives.NumberOfNodes(value))
    override val warmNodeCount: Optional[NumberOfNodes] = zio.aws.core.internal
      .optionalFromNullable(impl.warmNodeCount())
      .map(value => zio.aws.opensearch.model.primitives.NumberOfNodes(value))
    override val masterNode
        : Optional[zio.aws.opensearch.model.MasterNodeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterNode())
        .map(value => zio.aws.opensearch.model.MasterNodeStatus.wrap(value))
    override val clusterHealth
        : Optional[zio.aws.opensearch.model.DomainHealth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterHealth())
        .map(value => zio.aws.opensearch.model.DomainHealth.wrap(value))
    override val totalShards: Optional[NumberOfShards] = zio.aws.core.internal
      .optionalFromNullable(impl.totalShards())
      .map(value => zio.aws.opensearch.model.primitives.NumberOfShards(value))
    override val totalUnAssignedShards: Optional[NumberOfShards] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalUnAssignedShards())
        .map(value => zio.aws.opensearch.model.primitives.NumberOfShards(value))
    override val environmentInformation
        : Optional[List[zio.aws.opensearch.model.EnvironmentInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentInformation())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.EnvironmentInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthResponse
  ): zio.aws.opensearch.model.DescribeDomainHealthResponse.ReadOnly =
    new Wrapper(impl)
}
