package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class DescribeDomainHealthRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest = {
    import DescribeDomainHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDomainHealthRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainHealthRequest.wrap(buildAwsValue())
}
object DescribeDomainHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainHealthRequest =
      zio.aws.opensearch.model.DescribeDomainHealthRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest
  ) extends zio.aws.opensearch.model.DescribeDomainHealthRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest
  ): zio.aws.opensearch.model.DescribeDomainHealthRequest.ReadOnly =
    new Wrapper(impl)
}
