package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.VpcEndpointId
import scala.jdk.CollectionConverters._
final case class DeleteVpcEndpointRequest(vpcEndpointId: VpcEndpointId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest = {
    import DeleteVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest
      .builder()
      .vpcEndpointId(VpcEndpointId.unwrap(vpcEndpointId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DeleteVpcEndpointRequest.ReadOnly =
    zio.aws.opensearch.model.DeleteVpcEndpointRequest.wrap(buildAwsValue())
}
object DeleteVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DeleteVpcEndpointRequest =
      zio.aws.opensearch.model.DeleteVpcEndpointRequest(vpcEndpointId)
    def vpcEndpointId: VpcEndpointId
    def getVpcEndpointId: ZIO[Any, Nothing, VpcEndpointId] =
      ZIO.succeed(vpcEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest
  ) extends zio.aws.opensearch.model.DeleteVpcEndpointRequest.ReadOnly {
    override val vpcEndpointId: VpcEndpointId =
      zio.aws.opensearch.model.primitives.VpcEndpointId(impl.vpcEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest
  ): zio.aws.opensearch.model.DeleteVpcEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
