package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointResponse(
    vpcEndpoint: zio.aws.opensearch.model.VpcEndpoint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointResponse = {
    import CreateVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointResponse
      .builder()
      .vpcEndpoint(vpcEndpoint.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.CreateVpcEndpointResponse.ReadOnly =
    zio.aws.opensearch.model.CreateVpcEndpointResponse.wrap(buildAwsValue())
}
object CreateVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CreateVpcEndpointResponse =
      zio.aws.opensearch.model.CreateVpcEndpointResponse(vpcEndpoint.asEditable)
    def vpcEndpoint: zio.aws.opensearch.model.VpcEndpoint.ReadOnly
    def getVpcEndpoint
        : ZIO[Any, Nothing, zio.aws.opensearch.model.VpcEndpoint.ReadOnly] =
      ZIO.succeed(vpcEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointResponse
  ) extends zio.aws.opensearch.model.CreateVpcEndpointResponse.ReadOnly {
    override val vpcEndpoint: zio.aws.opensearch.model.VpcEndpoint.ReadOnly =
      zio.aws.opensearch.model.VpcEndpoint.wrap(impl.vpcEndpoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointResponse
  ): zio.aws.opensearch.model.CreateVpcEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
