package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{ClientToken, DomainArn}
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointRequest(
    domainArn: DomainArn,
    vpcOptions: zio.aws.opensearch.model.VPCOptions,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest = {
    import CreateVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest
      .builder()
      .domainArn(DomainArn.unwrap(domainArn): java.lang.String)
      .vpcOptions(vpcOptions.buildAwsValue())
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.CreateVpcEndpointRequest.ReadOnly =
    zio.aws.opensearch.model.CreateVpcEndpointRequest.wrap(buildAwsValue())
}
object CreateVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CreateVpcEndpointRequest =
      zio.aws.opensearch.model.CreateVpcEndpointRequest(
        domainArn,
        vpcOptions.asEditable,
        clientToken.map(value => value)
      )
    def domainArn: DomainArn
    def vpcOptions: zio.aws.opensearch.model.VPCOptions.ReadOnly
    def clientToken: Optional[ClientToken]
    def getDomainArn: ZIO[Any, Nothing, DomainArn] = ZIO.succeed(domainArn)
    def getVpcOptions
        : ZIO[Any, Nothing, zio.aws.opensearch.model.VPCOptions.ReadOnly] =
      ZIO.succeed(vpcOptions)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest
  ) extends zio.aws.opensearch.model.CreateVpcEndpointRequest.ReadOnly {
    override val domainArn: DomainArn =
      zio.aws.opensearch.model.primitives.DomainArn(impl.domainArn())
    override val vpcOptions: zio.aws.opensearch.model.VPCOptions.ReadOnly =
      zio.aws.opensearch.model.VPCOptions.wrap(impl.vpcOptions())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.opensearch.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest
  ): zio.aws.opensearch.model.CreateVpcEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
