package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.ConnectionAlias
import scala.jdk.CollectionConverters._
final case class CreateOutboundConnectionRequest(
    localDomainInfo: zio.aws.opensearch.model.DomainInformationContainer,
    remoteDomainInfo: zio.aws.opensearch.model.DomainInformationContainer,
    connectionAlias: ConnectionAlias,
    connectionMode: Optional[zio.aws.opensearch.model.ConnectionMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest = {
    import CreateOutboundConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest
      .builder()
      .localDomainInfo(localDomainInfo.buildAwsValue())
      .remoteDomainInfo(remoteDomainInfo.buildAwsValue())
      .connectionAlias(
        ConnectionAlias.unwrap(connectionAlias): java.lang.String
      )
      .optionallyWith(connectionMode.map(value => value.unwrap))(
        _.connectionMode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.CreateOutboundConnectionRequest.ReadOnly =
    zio.aws.opensearch.model.CreateOutboundConnectionRequest
      .wrap(buildAwsValue())
}
object CreateOutboundConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CreateOutboundConnectionRequest =
      zio.aws.opensearch.model.CreateOutboundConnectionRequest(
        localDomainInfo.asEditable,
        remoteDomainInfo.asEditable,
        connectionAlias,
        connectionMode.map(value => value)
      )
    def localDomainInfo
        : zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    def remoteDomainInfo
        : zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    def connectionAlias: ConnectionAlias
    def connectionMode: Optional[zio.aws.opensearch.model.ConnectionMode]
    def getLocalDomainInfo: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = ZIO.succeed(localDomainInfo)
    def getRemoteDomainInfo: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = ZIO.succeed(remoteDomainInfo)
    def getConnectionAlias: ZIO[Any, Nothing, ConnectionAlias] =
      ZIO.succeed(connectionAlias)
    def getConnectionMode
        : ZIO[Any, AwsError, zio.aws.opensearch.model.ConnectionMode] =
      AwsError.unwrapOptionField("connectionMode", connectionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest
  ) extends zio.aws.opensearch.model.CreateOutboundConnectionRequest.ReadOnly {
    override val localDomainInfo
        : zio.aws.opensearch.model.DomainInformationContainer.ReadOnly =
      zio.aws.opensearch.model.DomainInformationContainer
        .wrap(impl.localDomainInfo())
    override val remoteDomainInfo
        : zio.aws.opensearch.model.DomainInformationContainer.ReadOnly =
      zio.aws.opensearch.model.DomainInformationContainer
        .wrap(impl.remoteDomainInfo())
    override val connectionAlias: ConnectionAlias =
      zio.aws.opensearch.model.primitives
        .ConnectionAlias(impl.connectionAlias())
    override val connectionMode
        : Optional[zio.aws.opensearch.model.ConnectionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionMode())
        .map(value => zio.aws.opensearch.model.ConnectionMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest
  ): zio.aws.opensearch.model.CreateOutboundConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
