package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.Endpoint
import scala.jdk.CollectionConverters._
final case class ConnectionProperties(
    endpoint: Optional[Endpoint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ConnectionProperties = {
    import ConnectionProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ConnectionProperties
      .builder()
      .optionallyWith(
        endpoint.map(value => Endpoint.unwrap(value): java.lang.String)
      )(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ConnectionProperties.ReadOnly =
    zio.aws.opensearch.model.ConnectionProperties.wrap(buildAwsValue())
}
object ConnectionProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ConnectionProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ConnectionProperties =
      zio.aws.opensearch.model
        .ConnectionProperties(endpoint.map(value => value))
    def endpoint: Optional[Endpoint]
    def getEndpoint: ZIO[Any, AwsError, Endpoint] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ConnectionProperties
  ) extends zio.aws.opensearch.model.ConnectionProperties.ReadOnly {
    override val endpoint: Optional[Endpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.opensearch.model.primitives.Endpoint(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ConnectionProperties
  ): zio.aws.opensearch.model.ConnectionProperties.ReadOnly = new Wrapper(impl)
}
