package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionMode {
  def unwrap: software.amazon.awssdk.services.opensearch.model.ConnectionMode
}
object ConnectionMode {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.ConnectionMode
  ): zio.aws.opensearch.model.ConnectionMode = value match {
    case software.amazon.awssdk.services.opensearch.model.ConnectionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.ConnectionMode.DIRECT =>
      val r = DIRECT
      r
    case software.amazon.awssdk.services.opensearch.model.ConnectionMode.VPC_ENDPOINT =>
      val r = VPC_ENDPOINT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ConnectionMode =
      software.amazon.awssdk.services.opensearch.model.ConnectionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DIRECT extends zio.aws.opensearch.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ConnectionMode =
      software.amazon.awssdk.services.opensearch.model.ConnectionMode.DIRECT
  }
  case object VPC_ENDPOINT extends zio.aws.opensearch.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ConnectionMode =
      software.amazon.awssdk.services.opensearch.model.ConnectionMode.VPC_ENDPOINT
  }
}
