package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CognitoOptionsStatus(
    options: zio.aws.opensearch.model.CognitoOptions,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CognitoOptionsStatus = {
    import CognitoOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CognitoOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.CognitoOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.CognitoOptionsStatus.wrap(buildAwsValue())
}
object CognitoOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CognitoOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CognitoOptionsStatus =
      zio.aws.opensearch.model
        .CognitoOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.opensearch.model.CognitoOptions.ReadOnly
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions
        : ZIO[Any, Nothing, zio.aws.opensearch.model.CognitoOptions.ReadOnly] =
      ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CognitoOptionsStatus
  ) extends zio.aws.opensearch.model.CognitoOptionsStatus.ReadOnly {
    override val options: zio.aws.opensearch.model.CognitoOptions.ReadOnly =
      zio.aws.opensearch.model.CognitoOptions.wrap(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CognitoOptionsStatus
  ): zio.aws.opensearch.model.CognitoOptionsStatus.ReadOnly = new Wrapper(impl)
}
