package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{
  NumberOfShards,
  NumberOfNodes,
  AvailabilityZone
}
import scala.jdk.CollectionConverters._
final case class AvailabilityZoneInfo(
    availabilityZoneName: Optional[AvailabilityZone] = Optional.Absent,
    zoneStatus: Optional[zio.aws.opensearch.model.ZoneStatus] = Optional.Absent,
    configuredDataNodeCount: Optional[NumberOfNodes] = Optional.Absent,
    availableDataNodeCount: Optional[NumberOfNodes] = Optional.Absent,
    totalShards: Optional[NumberOfShards] = Optional.Absent,
    totalUnAssignedShards: Optional[NumberOfShards] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo = {
    import AvailabilityZoneInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo
      .builder()
      .optionallyWith(
        availabilityZoneName.map(value =>
          AvailabilityZone.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneName)
      .optionallyWith(zoneStatus.map(value => value.unwrap))(_.zoneStatus)
      .optionallyWith(
        configuredDataNodeCount.map(value =>
          NumberOfNodes.unwrap(value): java.lang.String
        )
      )(_.configuredDataNodeCount)
      .optionallyWith(
        availableDataNodeCount.map(value =>
          NumberOfNodes.unwrap(value): java.lang.String
        )
      )(_.availableDataNodeCount)
      .optionallyWith(
        totalShards.map(value => NumberOfShards.unwrap(value): java.lang.String)
      )(_.totalShards)
      .optionallyWith(
        totalUnAssignedShards.map(value =>
          NumberOfShards.unwrap(value): java.lang.String
        )
      )(_.totalUnAssignedShards)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AvailabilityZoneInfo.ReadOnly =
    zio.aws.opensearch.model.AvailabilityZoneInfo.wrap(buildAwsValue())
}
object AvailabilityZoneInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AvailabilityZoneInfo =
      zio.aws.opensearch.model.AvailabilityZoneInfo(
        availabilityZoneName.map(value => value),
        zoneStatus.map(value => value),
        configuredDataNodeCount.map(value => value),
        availableDataNodeCount.map(value => value),
        totalShards.map(value => value),
        totalUnAssignedShards.map(value => value)
      )
    def availabilityZoneName: Optional[AvailabilityZone]
    def zoneStatus: Optional[zio.aws.opensearch.model.ZoneStatus]
    def configuredDataNodeCount: Optional[NumberOfNodes]
    def availableDataNodeCount: Optional[NumberOfNodes]
    def totalShards: Optional[NumberOfShards]
    def totalUnAssignedShards: Optional[NumberOfShards]
    def getAvailabilityZoneName: ZIO[Any, AwsError, AvailabilityZone] =
      AwsError.unwrapOptionField("availabilityZoneName", availabilityZoneName)
    def getZoneStatus: ZIO[Any, AwsError, zio.aws.opensearch.model.ZoneStatus] =
      AwsError.unwrapOptionField("zoneStatus", zoneStatus)
    def getConfiguredDataNodeCount: ZIO[Any, AwsError, NumberOfNodes] = AwsError
      .unwrapOptionField("configuredDataNodeCount", configuredDataNodeCount)
    def getAvailableDataNodeCount: ZIO[Any, AwsError, NumberOfNodes] = AwsError
      .unwrapOptionField("availableDataNodeCount", availableDataNodeCount)
    def getTotalShards: ZIO[Any, AwsError, NumberOfShards] =
      AwsError.unwrapOptionField("totalShards", totalShards)
    def getTotalUnAssignedShards: ZIO[Any, AwsError, NumberOfShards] =
      AwsError.unwrapOptionField("totalUnAssignedShards", totalUnAssignedShards)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo
  ) extends zio.aws.opensearch.model.AvailabilityZoneInfo.ReadOnly {
    override val availabilityZoneName: Optional[AvailabilityZone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneName())
        .map(value =>
          zio.aws.opensearch.model.primitives.AvailabilityZone(value)
        )
    override val zoneStatus: Optional[zio.aws.opensearch.model.ZoneStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zoneStatus())
        .map(value => zio.aws.opensearch.model.ZoneStatus.wrap(value))
    override val configuredDataNodeCount: Optional[NumberOfNodes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuredDataNodeCount())
        .map(value => zio.aws.opensearch.model.primitives.NumberOfNodes(value))
    override val availableDataNodeCount: Optional[NumberOfNodes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableDataNodeCount())
        .map(value => zio.aws.opensearch.model.primitives.NumberOfNodes(value))
    override val totalShards: Optional[NumberOfShards] = zio.aws.core.internal
      .optionalFromNullable(impl.totalShards())
      .map(value => zio.aws.opensearch.model.primitives.NumberOfShards(value))
    override val totalUnAssignedShards: Optional[NumberOfShards] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalUnAssignedShards())
        .map(value => zio.aws.opensearch.model.primitives.NumberOfShards(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo
  ): zio.aws.opensearch.model.AvailabilityZoneInfo.ReadOnly = new Wrapper(impl)
}
