package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait AutoTuneState {
  def unwrap: software.amazon.awssdk.services.opensearch.model.AutoTuneState
}
object AutoTuneState {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.AutoTuneState
  ): zio.aws.opensearch.model.AutoTuneState = value match {
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.ENABLE_IN_PROGRESS =>
      val r = ENABLE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLE_IN_PROGRESS =>
      val r = DISABLE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_SCHEDULED =>
      val r = DISABLED_AND_ROLLBACK_SCHEDULED
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_IN_PROGRESS =>
      val r = DISABLED_AND_ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_COMPLETE =>
      val r = DISABLED_AND_ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_ERROR =>
      val r = DISABLED_AND_ROLLBACK_ERROR
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.ENABLED
  }
  case object DISABLED extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED
  }
  case object ENABLE_IN_PROGRESS
      extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.ENABLE_IN_PROGRESS
  }
  case object DISABLE_IN_PROGRESS
      extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLE_IN_PROGRESS
  }
  case object DISABLED_AND_ROLLBACK_SCHEDULED
      extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_SCHEDULED
  }
  case object DISABLED_AND_ROLLBACK_IN_PROGRESS
      extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_IN_PROGRESS
  }
  case object DISABLED_AND_ROLLBACK_COMPLETE
      extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_COMPLETE
  }
  case object DISABLED_AND_ROLLBACK_ERROR
      extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_ERROR
  }
  case object ERROR extends zio.aws.opensearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneState.ERROR
  }
}
