package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoTuneOptionsOutput(
    state: Optional[zio.aws.opensearch.model.AutoTuneState] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    useOffPeakWindow: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsOutput = {
    import AutoTuneOptionsOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsOutput
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(useOffPeakWindow.map(value => value: java.lang.Boolean))(
        _.useOffPeakWindow
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AutoTuneOptionsOutput.ReadOnly =
    zio.aws.opensearch.model.AutoTuneOptionsOutput.wrap(buildAwsValue())
}
object AutoTuneOptionsOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AutoTuneOptionsOutput =
      zio.aws.opensearch.model.AutoTuneOptionsOutput(
        state.map(value => value),
        errorMessage.map(value => value),
        useOffPeakWindow.map(value => value)
      )
    def state: Optional[zio.aws.opensearch.model.AutoTuneState]
    def errorMessage: Optional[String]
    def useOffPeakWindow: Optional[Boolean]
    def getState: ZIO[Any, AwsError, zio.aws.opensearch.model.AutoTuneState] =
      AwsError.unwrapOptionField("state", state)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getUseOffPeakWindow: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useOffPeakWindow", useOffPeakWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsOutput
  ) extends zio.aws.opensearch.model.AutoTuneOptionsOutput.ReadOnly {
    override val state: Optional[zio.aws.opensearch.model.AutoTuneState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.opensearch.model.AutoTuneState.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val useOffPeakWindow: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useOffPeakWindow())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsOutput
  ): zio.aws.opensearch.model.AutoTuneOptionsOutput.ReadOnly = new Wrapper(impl)
}
