package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuthorizedPrincipal(
    principalType: Optional[zio.aws.opensearch.model.PrincipalType] =
      Optional.Absent,
    principal: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AuthorizedPrincipal = {
    import AuthorizedPrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AuthorizedPrincipal
      .builder()
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .optionallyWith(principal.map(value => value: java.lang.String))(
        _.principal
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly =
    zio.aws.opensearch.model.AuthorizedPrincipal.wrap(buildAwsValue())
}
object AuthorizedPrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AuthorizedPrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AuthorizedPrincipal =
      zio.aws.opensearch.model.AuthorizedPrincipal(
        principalType.map(value => value),
        principal.map(value => value)
      )
    def principalType: Optional[zio.aws.opensearch.model.PrincipalType]
    def principal: Optional[String]
    def getPrincipalType
        : ZIO[Any, AwsError, zio.aws.opensearch.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getPrincipal: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principal", principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AuthorizedPrincipal
  ) extends zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly {
    override val principalType
        : Optional[zio.aws.opensearch.model.PrincipalType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalType())
        .map(value => zio.aws.opensearch.model.PrincipalType.wrap(value))
    override val principal: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AuthorizedPrincipal
  ): zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly = new Wrapper(impl)
}
