package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AuthorizeVpcEndpointAccessResponse(
    authorizedPrincipal: zio.aws.opensearch.model.AuthorizedPrincipal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessResponse = {
    import AuthorizeVpcEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessResponse
      .builder()
      .authorizedPrincipal(authorizedPrincipal.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse.ReadOnly =
    zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse
      .wrap(buildAwsValue())
}
object AuthorizeVpcEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse =
      zio.aws.opensearch.model
        .AuthorizeVpcEndpointAccessResponse(authorizedPrincipal.asEditable)
    def authorizedPrincipal
        : zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly
    def getAuthorizedPrincipal: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly
    ] = ZIO.succeed(authorizedPrincipal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessResponse
  ) extends zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse.ReadOnly {
    override val authorizedPrincipal
        : zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly =
      zio.aws.opensearch.model.AuthorizedPrincipal
        .wrap(impl.authorizedPrincipal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessResponse
  ): zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
