package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.{AWSAccount, DomainName}
import scala.jdk.CollectionConverters._
final case class AuthorizeVpcEndpointAccessRequest(
    domainName: DomainName,
    account: AWSAccount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest = {
    import AuthorizeVpcEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .account(AWSAccount.unwrap(account): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.AuthorizeVpcEndpointAccessRequest.ReadOnly =
    zio.aws.opensearch.model.AuthorizeVpcEndpointAccessRequest
      .wrap(buildAwsValue())
}
object AuthorizeVpcEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AuthorizeVpcEndpointAccessRequest =
      zio.aws.opensearch.model
        .AuthorizeVpcEndpointAccessRequest(domainName, account)
    def domainName: DomainName
    def account: AWSAccount
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getAccount: ZIO[Any, Nothing, AWSAccount] = ZIO.succeed(account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest
  ) extends zio.aws.opensearch.model.AuthorizeVpcEndpointAccessRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val account: AWSAccount =
      zio.aws.opensearch.model.primitives.AWSAccount(impl.account())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest
  ): zio.aws.opensearch.model.AuthorizeVpcEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
