package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait ActionType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.ActionType
}
object ActionType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.ActionType
  ): zio.aws.opensearch.model.ActionType = value match {
    case software.amazon.awssdk.services.opensearch.model.ActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.ActionType.SERVICE_SOFTWARE_UPDATE =>
      val r = SERVICE_SOFTWARE_UPDATE
      r
    case software.amazon.awssdk.services.opensearch.model.ActionType.JVM_HEAP_SIZE_TUNING =>
      val r = JVM_HEAP_SIZE_TUNING
      r
    case software.amazon.awssdk.services.opensearch.model.ActionType.JVM_YOUNG_GEN_TUNING =>
      val r = JVM_YOUNG_GEN_TUNING
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionType =
      software.amazon.awssdk.services.opensearch.model.ActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVICE_SOFTWARE_UPDATE
      extends zio.aws.opensearch.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionType =
      software.amazon.awssdk.services.opensearch.model.ActionType.SERVICE_SOFTWARE_UPDATE
  }
  case object JVM_HEAP_SIZE_TUNING extends zio.aws.opensearch.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionType =
      software.amazon.awssdk.services.opensearch.model.ActionType.JVM_HEAP_SIZE_TUNING
  }
  case object JVM_YOUNG_GEN_TUNING extends zio.aws.opensearch.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionType =
      software.amazon.awssdk.services.opensearch.model.ActionType.JVM_YOUNG_GEN_TUNING
  }
}
