package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait ActionStatus {
  def unwrap: software.amazon.awssdk.services.opensearch.model.ActionStatus
}
object ActionStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.ActionStatus
  ): zio.aws.opensearch.model.ActionStatus = value match {
    case software.amazon.awssdk.services.opensearch.model.ActionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.ActionStatus.PENDING_UPDATE =>
      val r = PENDING_UPDATE
      r
    case software.amazon.awssdk.services.opensearch.model.ActionStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.opensearch.model.ActionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.opensearch.model.ActionStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.opensearch.model.ActionStatus.NOT_ELIGIBLE =>
      val r = NOT_ELIGIBLE
      r
    case software.amazon.awssdk.services.opensearch.model.ActionStatus.ELIGIBLE =>
      val r = ELIGIBLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionStatus =
      software.amazon.awssdk.services.opensearch.model.ActionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_UPDATE extends zio.aws.opensearch.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionStatus =
      software.amazon.awssdk.services.opensearch.model.ActionStatus.PENDING_UPDATE
  }
  case object IN_PROGRESS extends zio.aws.opensearch.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionStatus =
      software.amazon.awssdk.services.opensearch.model.ActionStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.opensearch.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionStatus =
      software.amazon.awssdk.services.opensearch.model.ActionStatus.FAILED
  }
  case object COMPLETED extends zio.aws.opensearch.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionStatus =
      software.amazon.awssdk.services.opensearch.model.ActionStatus.COMPLETED
  }
  case object NOT_ELIGIBLE extends zio.aws.opensearch.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionStatus =
      software.amazon.awssdk.services.opensearch.model.ActionStatus.NOT_ELIGIBLE
  }
  case object ELIGIBLE extends zio.aws.opensearch.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionStatus =
      software.amazon.awssdk.services.opensearch.model.ActionStatus.ELIGIBLE
  }
}
