package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait ActionSeverity {
  def unwrap: software.amazon.awssdk.services.opensearch.model.ActionSeverity
}
object ActionSeverity {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.ActionSeverity
  ): zio.aws.opensearch.model.ActionSeverity = value match {
    case software.amazon.awssdk.services.opensearch.model.ActionSeverity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.ActionSeverity.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.opensearch.model.ActionSeverity.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.opensearch.model.ActionSeverity.LOW =>
      val r = LOW
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.ActionSeverity {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionSeverity =
      software.amazon.awssdk.services.opensearch.model.ActionSeverity.UNKNOWN_TO_SDK_VERSION
  }
  case object HIGH extends zio.aws.opensearch.model.ActionSeverity {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionSeverity =
      software.amazon.awssdk.services.opensearch.model.ActionSeverity.HIGH
  }
  case object MEDIUM extends zio.aws.opensearch.model.ActionSeverity {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionSeverity =
      software.amazon.awssdk.services.opensearch.model.ActionSeverity.MEDIUM
  }
  case object LOW extends zio.aws.opensearch.model.ActionSeverity {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ActionSeverity =
      software.amazon.awssdk.services.opensearch.model.ActionSeverity.LOW
  }
}
