package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptInboundConnectionResponse(
    connection: Optional[zio.aws.opensearch.model.InboundConnection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse = {
    import AcceptInboundConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.AcceptInboundConnectionResponse.ReadOnly =
    zio.aws.opensearch.model.AcceptInboundConnectionResponse
      .wrap(buildAwsValue())
}
object AcceptInboundConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AcceptInboundConnectionResponse =
      zio.aws.opensearch.model.AcceptInboundConnectionResponse(
        connection.map(value => value.asEditable)
      )
    def connection
        : Optional[zio.aws.opensearch.model.InboundConnection.ReadOnly]
    def getConnection: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.InboundConnection.ReadOnly
    ] = AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse
  ) extends zio.aws.opensearch.model.AcceptInboundConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.opensearch.model.InboundConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.opensearch.model.InboundConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse
  ): zio.aws.opensearch.model.AcceptInboundConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
