package zio.aws.opensearch
import zio.aws.opensearch.model.DeleteDomainResponse.ReadOnly
import zio.aws.opensearch.model.primitives.VersionString
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.opensearch.model.{
  InstanceTypeDetails,
  ListVpcEndpointsForDomainResponse,
  DeleteOutboundConnectionRequest,
  DescribeVpcEndpointsRequest,
  ListVpcEndpointsResponse,
  PackageDetails,
  ListVpcEndpointsForDomainRequest,
  GetCompatibleVersionsResponse,
  DeleteInboundConnectionRequest,
  DescribeDomainConfigRequest,
  AssociatePackageRequest,
  GetUpgradeHistoryRequest,
  DescribeReservedInstanceOfferingsRequest,
  CreateVpcEndpointResponse,
  GetUpgradeStatusResponse,
  DescribeReservedInstancesResponse,
  CreateDomainResponse,
  CancelServiceSoftwareUpdateRequest,
  DescribeDomainResponse,
  StartServiceSoftwareUpdateResponse,
  UpdatePackageResponse,
  AssociatePackageResponse,
  UpdateVpcEndpointRequest,
  GetPackageVersionHistoryResponse,
  DescribePackagesRequest,
  RevokeVpcEndpointAccessResponse,
  DescribeInstanceTypeLimitsRequest,
  DescribeDomainHealthRequest,
  GetCompatibleVersionsRequest,
  ListTagsRequest,
  DescribeVpcEndpointsResponse,
  ListPackagesForDomainResponse,
  RejectInboundConnectionRequest,
  DescribeDryRunProgressResponse,
  DescribeDomainAutoTunesRequest,
  ListScheduledActionsRequest,
  InboundConnection,
  CreatePackageResponse,
  UpdateDomainConfigRequest,
  DescribeInboundConnectionsRequest,
  ListPackagesForDomainRequest,
  RemoveTagsResponse,
  DescribeDomainsRequest,
  DescribeDomainChangeProgressResponse,
  ListDomainsForPackageResponse,
  PackageVersionHistory,
  ListVpcEndpointsRequest,
  DeletePackageRequest,
  DomainPackageDetails,
  ListVersionsRequest,
  GetPackageVersionHistoryRequest,
  DeleteOutboundConnectionResponse,
  ReservedInstanceOffering,
  DescribeDomainConfigResponse,
  UpdateScheduledActionRequest,
  ListInstanceTypeDetailsRequest,
  ListVpcEndpointAccessResponse,
  DeleteVpcEndpointResponse,
  DeleteVpcEndpointRequest,
  AcceptInboundConnectionRequest,
  AutoTune,
  ReservedInstance,
  CreatePackageRequest,
  AddTagsRequest,
  DescribeDomainChangeProgressRequest,
  ListDomainNamesRequest,
  UpdateVpcEndpointResponse,
  DescribeDomainsResponse,
  DeleteDomainRequest,
  RejectInboundConnectionResponse,
  UpgradeHistory,
  DescribeDomainHealthResponse,
  UpdateDomainConfigResponse,
  DescribeInboundConnectionsResponse,
  DissociatePackageResponse,
  ListVpcEndpointAccessRequest,
  DescribeReservedInstanceOfferingsResponse,
  GetUpgradeStatusRequest,
  DescribeDomainRequest,
  AuthorizeVpcEndpointAccessRequest,
  AuthorizeVpcEndpointAccessResponse,
  DescribeInstanceTypeLimitsResponse,
  DeleteInboundConnectionResponse,
  UpgradeDomainResponse,
  CreateVpcEndpointRequest,
  StartServiceSoftwareUpdateRequest,
  AddTagsResponse,
  CreateOutboundConnectionRequest,
  CancelServiceSoftwareUpdateResponse,
  DescribeReservedInstancesRequest,
  DescribeOutboundConnectionsResponse,
  CreateDomainRequest,
  OutboundConnection,
  CreateOutboundConnectionResponse,
  VpcEndpointSummary,
  RevokeVpcEndpointAccessRequest,
  ScheduledAction,
  PurchaseReservedInstanceOfferingRequest,
  GetUpgradeHistoryResponse,
  DescribeDomainNodesRequest,
  UpgradeDomainRequest,
  AcceptInboundConnectionResponse,
  DescribeOutboundConnectionsRequest,
  DescribeDryRunProgressRequest,
  ListScheduledActionsResponse,
  ListInstanceTypeDetailsResponse,
  DissociatePackageRequest,
  RemoveTagsRequest,
  DeletePackageResponse,
  UpdateScheduledActionResponse,
  AuthorizedPrincipal,
  DescribeDomainAutoTunesResponse,
  ListDomainNamesResponse,
  DeleteDomainResponse,
  ListTagsResponse,
  ListDomainsForPackageRequest,
  DescribePackagesResponse,
  UpdatePackageRequest,
  PurchaseReservedInstanceOfferingResponse,
  ListVersionsResponse,
  DescribeDomainNodesResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.opensearch.{
  OpenSearchAsyncClientBuilder,
  OpenSearchAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait OpenSearch extends AspectSupport[OpenSearch] {
  val api: OpenSearchAsyncClient
  def describeDryRunProgress(
      request: zio.aws.opensearch.model.DescribeDryRunProgressRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeDryRunProgressResponse.ReadOnly
  ]
  def describePackages(
      request: zio.aws.opensearch.model.DescribePackagesRequest
  ): ZStream[Any, AwsError, zio.aws.opensearch.model.PackageDetails.ReadOnly]
  def describePackagesPaginated(
      request: zio.aws.opensearch.model.DescribePackagesRequest
  ): IO[AwsError, zio.aws.opensearch.model.DescribePackagesResponse.ReadOnly]
  def startServiceSoftwareUpdate(
      request: zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.ReadOnly
  ]
  def getCompatibleVersions(
      request: zio.aws.opensearch.model.GetCompatibleVersionsRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.GetCompatibleVersionsResponse.ReadOnly
  ]
  def listVpcEndpointAccess(
      request: zio.aws.opensearch.model.ListVpcEndpointAccessRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly
  ]
  def listVpcEndpointAccessPaginated(
      request: zio.aws.opensearch.model.ListVpcEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.ListVpcEndpointAccessResponse.ReadOnly
  ]
  def associatePackage(
      request: zio.aws.opensearch.model.AssociatePackageRequest
  ): IO[AwsError, zio.aws.opensearch.model.AssociatePackageResponse.ReadOnly]
  def listVpcEndpointsForDomain(
      request: zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly
  ]
  def listVpcEndpointsForDomainPaginated(
      request: zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse.ReadOnly
  ]
  def describeDomain(
      request: zio.aws.opensearch.model.DescribeDomainRequest
  ): IO[AwsError, zio.aws.opensearch.model.DescribeDomainResponse.ReadOnly]
  def createPackage(
      request: zio.aws.opensearch.model.CreatePackageRequest
  ): IO[AwsError, zio.aws.opensearch.model.CreatePackageResponse.ReadOnly]
  def listTags(
      request: zio.aws.opensearch.model.ListTagsRequest
  ): IO[AwsError, zio.aws.opensearch.model.ListTagsResponse.ReadOnly]
  def deleteOutboundConnection(
      request: zio.aws.opensearch.model.DeleteOutboundConnectionRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DeleteOutboundConnectionResponse.ReadOnly
  ]
  def addTags(
      request: zio.aws.opensearch.model.AddTagsRequest
  ): IO[AwsError, Unit]
  def dissociatePackage(
      request: zio.aws.opensearch.model.DissociatePackageRequest
  ): IO[AwsError, zio.aws.opensearch.model.DissociatePackageResponse.ReadOnly]
  def updateDomainConfig(
      request: zio.aws.opensearch.model.UpdateDomainConfigRequest
  ): IO[AwsError, zio.aws.opensearch.model.UpdateDomainConfigResponse.ReadOnly]
  def describeReservedInstances(
      request: zio.aws.opensearch.model.DescribeReservedInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.opensearch.model.ReservedInstance.ReadOnly]
  def describeReservedInstancesPaginated(
      request: zio.aws.opensearch.model.DescribeReservedInstancesRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeReservedInstancesResponse.ReadOnly
  ]
  def describeDomainNodes(
      request: zio.aws.opensearch.model.DescribeDomainNodesRequest
  ): IO[AwsError, zio.aws.opensearch.model.DescribeDomainNodesResponse.ReadOnly]
  def listDomainsForPackage(
      request: zio.aws.opensearch.model.ListDomainsForPackageRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
  ]
  def listDomainsForPackagePaginated(
      request: zio.aws.opensearch.model.ListDomainsForPackageRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.ListDomainsForPackageResponse.ReadOnly
  ]
  def createOutboundConnection(
      request: zio.aws.opensearch.model.CreateOutboundConnectionRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.CreateOutboundConnectionResponse.ReadOnly
  ]
  def upgradeDomain(
      request: zio.aws.opensearch.model.UpgradeDomainRequest
  ): IO[AwsError, zio.aws.opensearch.model.UpgradeDomainResponse.ReadOnly]
  def describeOutboundConnections(
      request: zio.aws.opensearch.model.DescribeOutboundConnectionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.opensearch.model.OutboundConnection.ReadOnly
  ]
  def describeOutboundConnectionsPaginated(
      request: zio.aws.opensearch.model.DescribeOutboundConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.ReadOnly
  ]
  def describeDomainChangeProgress(
      request: zio.aws.opensearch.model.DescribeDomainChangeProgressRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.ReadOnly
  ]
  def removeTags(
      request: zio.aws.opensearch.model.RemoveTagsRequest
  ): IO[AwsError, Unit]
  def getUpgradeHistory(
      request: zio.aws.opensearch.model.GetUpgradeHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.opensearch.model.UpgradeHistory.ReadOnly]
  def getUpgradeHistoryPaginated(
      request: zio.aws.opensearch.model.GetUpgradeHistoryRequest
  ): IO[AwsError, zio.aws.opensearch.model.GetUpgradeHistoryResponse.ReadOnly]
  def createDomain(
      request: zio.aws.opensearch.model.CreateDomainRequest
  ): IO[AwsError, zio.aws.opensearch.model.CreateDomainResponse.ReadOnly]
  def revokeVpcEndpointAccess(
      request: zio.aws.opensearch.model.RevokeVpcEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.RevokeVpcEndpointAccessResponse.ReadOnly
  ]
  def listPackagesForDomain(
      request: zio.aws.opensearch.model.ListPackagesForDomainRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
  ]
  def listPackagesForDomainPaginated(
      request: zio.aws.opensearch.model.ListPackagesForDomainRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.ListPackagesForDomainResponse.ReadOnly
  ]
  def describeInboundConnections(
      request: zio.aws.opensearch.model.DescribeInboundConnectionsRequest
  ): ZStream[Any, AwsError, zio.aws.opensearch.model.InboundConnection.ReadOnly]
  def describeInboundConnectionsPaginated(
      request: zio.aws.opensearch.model.DescribeInboundConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeInboundConnectionsResponse.ReadOnly
  ]
  def listVersions(
      request: zio.aws.opensearch.model.ListVersionsRequest
  ): ZStream[Any, AwsError, VersionString]
  def listVersionsPaginated(
      request: zio.aws.opensearch.model.ListVersionsRequest
  ): IO[AwsError, zio.aws.opensearch.model.ListVersionsResponse.ReadOnly]
  def getPackageVersionHistory(
      request: zio.aws.opensearch.model.GetPackageVersionHistoryRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly,
    zio.aws.opensearch.model.PackageVersionHistory.ReadOnly
  ]]
  def getPackageVersionHistoryPaginated(
      request: zio.aws.opensearch.model.GetPackageVersionHistoryRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly
  ]
  def listVpcEndpoints(
      request: zio.aws.opensearch.model.ListVpcEndpointsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly
  ]
  def listVpcEndpointsPaginated(
      request: zio.aws.opensearch.model.ListVpcEndpointsRequest
  ): IO[AwsError, zio.aws.opensearch.model.ListVpcEndpointsResponse.ReadOnly]
  def deleteVpcEndpoint(
      request: zio.aws.opensearch.model.DeleteVpcEndpointRequest
  ): IO[AwsError, zio.aws.opensearch.model.DeleteVpcEndpointResponse.ReadOnly]
  def createVpcEndpoint(
      request: zio.aws.opensearch.model.CreateVpcEndpointRequest
  ): IO[AwsError, zio.aws.opensearch.model.CreateVpcEndpointResponse.ReadOnly]
  def cancelServiceSoftwareUpdate(
      request: zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.ReadOnly
  ]
  def describeDomainConfig(
      request: zio.aws.opensearch.model.DescribeDomainConfigRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeDomainConfigResponse.ReadOnly
  ]
  def describeDomains(
      request: zio.aws.opensearch.model.DescribeDomainsRequest
  ): IO[AwsError, zio.aws.opensearch.model.DescribeDomainsResponse.ReadOnly]
  def describeDomainAutoTunes(
      request: zio.aws.opensearch.model.DescribeDomainAutoTunesRequest
  ): ZStream[Any, AwsError, zio.aws.opensearch.model.AutoTune.ReadOnly]
  def describeDomainAutoTunesPaginated(
      request: zio.aws.opensearch.model.DescribeDomainAutoTunesRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.ReadOnly
  ]
  def listInstanceTypeDetails(
      request: zio.aws.opensearch.model.ListInstanceTypeDetailsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly
  ]
  def listInstanceTypeDetailsPaginated(
      request: zio.aws.opensearch.model.ListInstanceTypeDetailsRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.ReadOnly
  ]
  def updatePackage(
      request: zio.aws.opensearch.model.UpdatePackageRequest
  ): IO[AwsError, zio.aws.opensearch.model.UpdatePackageResponse.ReadOnly]
  def deletePackage(
      request: zio.aws.opensearch.model.DeletePackageRequest
  ): IO[AwsError, zio.aws.opensearch.model.DeletePackageResponse.ReadOnly]
  def deleteDomain(
      request: zio.aws.opensearch.model.DeleteDomainRequest
  ): IO[AwsError, ReadOnly]
  def describeInstanceTypeLimits(
      request: zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.ReadOnly
  ]
  def acceptInboundConnection(
      request: zio.aws.opensearch.model.AcceptInboundConnectionRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.AcceptInboundConnectionResponse.ReadOnly
  ]
  def describeVpcEndpoints(
      request: zio.aws.opensearch.model.DescribeVpcEndpointsRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeVpcEndpointsResponse.ReadOnly
  ]
  def deleteInboundConnection(
      request: zio.aws.opensearch.model.DeleteInboundConnectionRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DeleteInboundConnectionResponse.ReadOnly
  ]
  def describeDomainHealth(
      request: zio.aws.opensearch.model.DescribeDomainHealthRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeDomainHealthResponse.ReadOnly
  ]
  def purchaseReservedInstanceOffering(
      request: zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.ReadOnly
  ]
  def getUpgradeStatus(
      request: zio.aws.opensearch.model.GetUpgradeStatusRequest
  ): IO[AwsError, zio.aws.opensearch.model.GetUpgradeStatusResponse.ReadOnly]
  def listDomainNames(
      request: zio.aws.opensearch.model.ListDomainNamesRequest
  ): IO[AwsError, zio.aws.opensearch.model.ListDomainNamesResponse.ReadOnly]
  def rejectInboundConnection(
      request: zio.aws.opensearch.model.RejectInboundConnectionRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.RejectInboundConnectionResponse.ReadOnly
  ]
  def authorizeVpcEndpointAccess(
      request: zio.aws.opensearch.model.AuthorizeVpcEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse.ReadOnly
  ]
  def listScheduledActions(
      request: zio.aws.opensearch.model.ListScheduledActionsRequest
  ): ZStream[Any, AwsError, zio.aws.opensearch.model.ScheduledAction.ReadOnly]
  def listScheduledActionsPaginated(
      request: zio.aws.opensearch.model.ListScheduledActionsRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.ListScheduledActionsResponse.ReadOnly
  ]
  def describeReservedInstanceOfferings(
      request: zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly
  ]
  def describeReservedInstanceOfferingsPaginated(
      request: zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.ReadOnly
  ]
  def updateVpcEndpoint(
      request: zio.aws.opensearch.model.UpdateVpcEndpointRequest
  ): IO[AwsError, zio.aws.opensearch.model.UpdateVpcEndpointResponse.ReadOnly]
  def updateScheduledAction(
      request: zio.aws.opensearch.model.UpdateScheduledActionRequest
  ): IO[
    AwsError,
    zio.aws.opensearch.model.UpdateScheduledActionResponse.ReadOnly
  ]
}
object OpenSearch {
  val live: ZLayer[AwsConfig, java.lang.Throwable, OpenSearch] = customized(
    identity
  )
  def customized(
      customization: OpenSearchAsyncClientBuilder => OpenSearchAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, OpenSearch] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: OpenSearchAsyncClientBuilder => OpenSearchAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, OpenSearch] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = OpenSearchAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[OpenSearchAsyncClient, OpenSearchAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[OpenSearchAsyncClient, OpenSearchAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new OpenSearchImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class OpenSearchImpl[R](
      override val api: OpenSearchAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends OpenSearch
      with AwsServiceBase[R] {
    override val serviceName: String = "OpenSearch"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): OpenSearchImpl[R1] = new OpenSearchImpl(api, newAspect, r)
    def describeDryRunProgress(
        request: zio.aws.opensearch.model.DescribeDryRunProgressRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeDryRunProgressResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDryRunProgressRequest,
      DescribeDryRunProgressResponse
    ]("describeDryRunProgress", api.describeDryRunProgress)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DescribeDryRunProgressResponse.wrap)
      .provideEnvironment(r)
    def describePackages(
        request: zio.aws.opensearch.model.DescribePackagesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.PackageDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribePackagesRequest,
      DescribePackagesResponse,
      PackageDetails
    ](
      "describePackages",
      api.describePackages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.packageDetailsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.PackageDetails.wrap(item))
      .provideEnvironment(r)
    def describePackagesPaginated(
        request: zio.aws.opensearch.model.DescribePackagesRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribePackagesResponse.ReadOnly
    ] = asyncRequestResponse[DescribePackagesRequest, DescribePackagesResponse](
      "describePackages",
      api.describePackages
    )(request.buildAwsValue())
      .map(zio.aws.opensearch.model.DescribePackagesResponse.wrap)
      .provideEnvironment(r)
    def startServiceSoftwareUpdate(
        request: zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.ReadOnly
    ] = asyncRequestResponse[
      StartServiceSoftwareUpdateRequest,
      StartServiceSoftwareUpdateResponse
    ]("startServiceSoftwareUpdate", api.startServiceSoftwareUpdate)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.wrap)
      .provideEnvironment(r)
    def getCompatibleVersions(
        request: zio.aws.opensearch.model.GetCompatibleVersionsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.GetCompatibleVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCompatibleVersionsRequest,
      GetCompatibleVersionsResponse
    ]("getCompatibleVersions", api.getCompatibleVersions)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.GetCompatibleVersionsResponse.wrap)
      .provideEnvironment(r)
    def listVpcEndpointAccess(
        request: zio.aws.opensearch.model.ListVpcEndpointAccessRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListVpcEndpointAccessRequest,
      ListVpcEndpointAccessResponse,
      AuthorizedPrincipal
    ](
      "listVpcEndpointAccess",
      api.listVpcEndpointAccess,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.authorizedPrincipalList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.AuthorizedPrincipal.wrap(item))
      .provideEnvironment(r)
    def listVpcEndpointAccessPaginated(
        request: zio.aws.opensearch.model.ListVpcEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.ListVpcEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVpcEndpointAccessRequest,
      ListVpcEndpointAccessResponse
    ]("listVpcEndpointAccess", api.listVpcEndpointAccess)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.ListVpcEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def associatePackage(
        request: zio.aws.opensearch.model.AssociatePackageRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.AssociatePackageResponse.ReadOnly
    ] = asyncRequestResponse[AssociatePackageRequest, AssociatePackageResponse](
      "associatePackage",
      api.associatePackage
    )(request.buildAwsValue())
      .map(zio.aws.opensearch.model.AssociatePackageResponse.wrap)
      .provideEnvironment(r)
    def listVpcEndpointsForDomain(
        request: zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListVpcEndpointsForDomainRequest,
      ListVpcEndpointsForDomainResponse,
      VpcEndpointSummary
    ](
      "listVpcEndpointsForDomain",
      api.listVpcEndpointsForDomain,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vpcEndpointSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.VpcEndpointSummary.wrap(item))
      .provideEnvironment(r)
    def listVpcEndpointsForDomainPaginated(
        request: zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVpcEndpointsForDomainRequest,
      ListVpcEndpointsForDomainResponse
    ]("listVpcEndpointsForDomain", api.listVpcEndpointsForDomain)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse.wrap)
      .provideEnvironment(r)
    def describeDomain(
        request: zio.aws.opensearch.model.DescribeDomainRequest
    ): IO[AwsError, zio.aws.opensearch.model.DescribeDomainResponse.ReadOnly] =
      asyncRequestResponse[DescribeDomainRequest, DescribeDomainResponse](
        "describeDomain",
        api.describeDomain
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.DescribeDomainResponse.wrap)
        .provideEnvironment(r)
    def createPackage(
        request: zio.aws.opensearch.model.CreatePackageRequest
    ): IO[AwsError, zio.aws.opensearch.model.CreatePackageResponse.ReadOnly] =
      asyncRequestResponse[CreatePackageRequest, CreatePackageResponse](
        "createPackage",
        api.createPackage
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.CreatePackageResponse.wrap)
        .provideEnvironment(r)
    def listTags(
        request: zio.aws.opensearch.model.ListTagsRequest
    ): IO[AwsError, zio.aws.opensearch.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[ListTagsRequest, ListTagsResponse](
        "listTags",
        api.listTags
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def deleteOutboundConnection(
        request: zio.aws.opensearch.model.DeleteOutboundConnectionRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DeleteOutboundConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteOutboundConnectionRequest,
      DeleteOutboundConnectionResponse
    ]("deleteOutboundConnection", api.deleteOutboundConnection)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DeleteOutboundConnectionResponse.wrap)
      .provideEnvironment(r)
    def addTags(
        request: zio.aws.opensearch.model.AddTagsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AddTagsRequest, AddTagsResponse](
        "addTags",
        api.addTags
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def dissociatePackage(
        request: zio.aws.opensearch.model.DissociatePackageRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DissociatePackageResponse.ReadOnly
    ] =
      asyncRequestResponse[DissociatePackageRequest, DissociatePackageResponse](
        "dissociatePackage",
        api.dissociatePackage
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.DissociatePackageResponse.wrap)
        .provideEnvironment(r)
    def updateDomainConfig(
        request: zio.aws.opensearch.model.UpdateDomainConfigRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.UpdateDomainConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDomainConfigRequest,
      UpdateDomainConfigResponse
    ]("updateDomainConfig", api.updateDomainConfig)(request.buildAwsValue())
      .map(zio.aws.opensearch.model.UpdateDomainConfigResponse.wrap)
      .provideEnvironment(r)
    def describeReservedInstances(
        request: zio.aws.opensearch.model.DescribeReservedInstancesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.ReservedInstance.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeReservedInstancesRequest,
      DescribeReservedInstancesResponse,
      ReservedInstance
    ](
      "describeReservedInstances",
      api.describeReservedInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.reservedInstances().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.ReservedInstance.wrap(item))
      .provideEnvironment(r)
    def describeReservedInstancesPaginated(
        request: zio.aws.opensearch.model.DescribeReservedInstancesRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeReservedInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReservedInstancesRequest,
      DescribeReservedInstancesResponse
    ]("describeReservedInstances", api.describeReservedInstances)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DescribeReservedInstancesResponse.wrap)
      .provideEnvironment(r)
    def describeDomainNodes(
        request: zio.aws.opensearch.model.DescribeDomainNodesRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeDomainNodesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDomainNodesRequest,
      DescribeDomainNodesResponse
    ]("describeDomainNodes", api.describeDomainNodes)(request.buildAwsValue())
      .map(zio.aws.opensearch.model.DescribeDomainNodesResponse.wrap)
      .provideEnvironment(r)
    def listDomainsForPackage(
        request: zio.aws.opensearch.model.ListDomainsForPackageRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDomainsForPackageRequest,
      ListDomainsForPackageResponse,
      DomainPackageDetails
    ](
      "listDomainsForPackage",
      api.listDomainsForPackage,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.domainPackageDetailsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.DomainPackageDetails.wrap(item))
      .provideEnvironment(r)
    def listDomainsForPackagePaginated(
        request: zio.aws.opensearch.model.ListDomainsForPackageRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.ListDomainsForPackageResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDomainsForPackageRequest,
      ListDomainsForPackageResponse
    ]("listDomainsForPackage", api.listDomainsForPackage)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.ListDomainsForPackageResponse.wrap)
      .provideEnvironment(r)
    def createOutboundConnection(
        request: zio.aws.opensearch.model.CreateOutboundConnectionRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.CreateOutboundConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateOutboundConnectionRequest,
      CreateOutboundConnectionResponse
    ]("createOutboundConnection", api.createOutboundConnection)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.CreateOutboundConnectionResponse.wrap)
      .provideEnvironment(r)
    def upgradeDomain(
        request: zio.aws.opensearch.model.UpgradeDomainRequest
    ): IO[AwsError, zio.aws.opensearch.model.UpgradeDomainResponse.ReadOnly] =
      asyncRequestResponse[UpgradeDomainRequest, UpgradeDomainResponse](
        "upgradeDomain",
        api.upgradeDomain
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.UpgradeDomainResponse.wrap)
        .provideEnvironment(r)
    def describeOutboundConnections(
        request: zio.aws.opensearch.model.DescribeOutboundConnectionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.OutboundConnection.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeOutboundConnectionsRequest,
      DescribeOutboundConnectionsResponse,
      OutboundConnection
    ](
      "describeOutboundConnections",
      api.describeOutboundConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connections().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.OutboundConnection.wrap(item))
      .provideEnvironment(r)
    def describeOutboundConnectionsPaginated(
        request: zio.aws.opensearch.model.DescribeOutboundConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOutboundConnectionsRequest,
      DescribeOutboundConnectionsResponse
    ]("describeOutboundConnections", api.describeOutboundConnections)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.wrap)
      .provideEnvironment(r)
    def describeDomainChangeProgress(
        request: zio.aws.opensearch.model.DescribeDomainChangeProgressRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDomainChangeProgressRequest,
      DescribeDomainChangeProgressResponse
    ]("describeDomainChangeProgress", api.describeDomainChangeProgress)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.wrap)
      .provideEnvironment(r)
    def removeTags(
        request: zio.aws.opensearch.model.RemoveTagsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[RemoveTagsRequest, RemoveTagsResponse](
        "removeTags",
        api.removeTags
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getUpgradeHistory(
        request: zio.aws.opensearch.model.GetUpgradeHistoryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.UpgradeHistory.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetUpgradeHistoryRequest,
      GetUpgradeHistoryResponse,
      UpgradeHistory
    ](
      "getUpgradeHistory",
      api.getUpgradeHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.upgradeHistories().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.UpgradeHistory.wrap(item))
      .provideEnvironment(r)
    def getUpgradeHistoryPaginated(
        request: zio.aws.opensearch.model.GetUpgradeHistoryRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.GetUpgradeHistoryResponse.ReadOnly
    ] =
      asyncRequestResponse[GetUpgradeHistoryRequest, GetUpgradeHistoryResponse](
        "getUpgradeHistory",
        api.getUpgradeHistory
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.GetUpgradeHistoryResponse.wrap)
        .provideEnvironment(r)
    def createDomain(
        request: zio.aws.opensearch.model.CreateDomainRequest
    ): IO[AwsError, zio.aws.opensearch.model.CreateDomainResponse.ReadOnly] =
      asyncRequestResponse[CreateDomainRequest, CreateDomainResponse](
        "createDomain",
        api.createDomain
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.CreateDomainResponse.wrap)
        .provideEnvironment(r)
    def revokeVpcEndpointAccess(
        request: zio.aws.opensearch.model.RevokeVpcEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.RevokeVpcEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      RevokeVpcEndpointAccessRequest,
      RevokeVpcEndpointAccessResponse
    ]("revokeVpcEndpointAccess", api.revokeVpcEndpointAccess)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.RevokeVpcEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def listPackagesForDomain(
        request: zio.aws.opensearch.model.ListPackagesForDomainRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListPackagesForDomainRequest,
      ListPackagesForDomainResponse,
      DomainPackageDetails
    ](
      "listPackagesForDomain",
      api.listPackagesForDomain,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.domainPackageDetailsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.DomainPackageDetails.wrap(item))
      .provideEnvironment(r)
    def listPackagesForDomainPaginated(
        request: zio.aws.opensearch.model.ListPackagesForDomainRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.ListPackagesForDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPackagesForDomainRequest,
      ListPackagesForDomainResponse
    ]("listPackagesForDomain", api.listPackagesForDomain)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.ListPackagesForDomainResponse.wrap)
      .provideEnvironment(r)
    def describeInboundConnections(
        request: zio.aws.opensearch.model.DescribeInboundConnectionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.InboundConnection.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeInboundConnectionsRequest,
      DescribeInboundConnectionsResponse,
      InboundConnection
    ](
      "describeInboundConnections",
      api.describeInboundConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connections().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.InboundConnection.wrap(item))
      .provideEnvironment(r)
    def describeInboundConnectionsPaginated(
        request: zio.aws.opensearch.model.DescribeInboundConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeInboundConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInboundConnectionsRequest,
      DescribeInboundConnectionsResponse
    ]("describeInboundConnections", api.describeInboundConnections)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DescribeInboundConnectionsResponse.wrap)
      .provideEnvironment(r)
    def listVersions(
        request: zio.aws.opensearch.model.ListVersionsRequest
    ): ZStream[Any, AwsError, VersionString] = asyncSimplePaginatedRequest[
      ListVersionsRequest,
      ListVersionsResponse,
      java.lang.String
    ](
      "listVersions",
      api.listVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.versions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.primitives.VersionString(item))
      .provideEnvironment(r)
    def listVersionsPaginated(
        request: zio.aws.opensearch.model.ListVersionsRequest
    ): IO[AwsError, zio.aws.opensearch.model.ListVersionsResponse.ReadOnly] =
      asyncRequestResponse[ListVersionsRequest, ListVersionsResponse](
        "listVersions",
        api.listVersions
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.ListVersionsResponse.wrap)
        .provideEnvironment(r)
    def getPackageVersionHistory(
        request: zio.aws.opensearch.model.GetPackageVersionHistoryRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly,
      zio.aws.opensearch.model.PackageVersionHistory.ReadOnly
    ]] = asyncPaginatedRequest[
      GetPackageVersionHistoryRequest,
      GetPackageVersionHistoryResponse,
      PackageVersionHistory
    ](
      "getPackageVersionHistory",
      api.getPackageVersionHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.packageVersionHistoryList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.opensearch.model.GetPackageVersionHistoryResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.opensearch.model.PackageVersionHistory.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getPackageVersionHistoryPaginated(
        request: zio.aws.opensearch.model.GetPackageVersionHistoryRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPackageVersionHistoryRequest,
      GetPackageVersionHistoryResponse
    ]("getPackageVersionHistory", api.getPackageVersionHistory)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.GetPackageVersionHistoryResponse.wrap)
      .provideEnvironment(r)
    def listVpcEndpoints(
        request: zio.aws.opensearch.model.ListVpcEndpointsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListVpcEndpointsRequest,
      ListVpcEndpointsResponse,
      VpcEndpointSummary
    ](
      "listVpcEndpoints",
      api.listVpcEndpoints,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vpcEndpointSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.VpcEndpointSummary.wrap(item))
      .provideEnvironment(r)
    def listVpcEndpointsPaginated(
        request: zio.aws.opensearch.model.ListVpcEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.ListVpcEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[ListVpcEndpointsRequest, ListVpcEndpointsResponse](
      "listVpcEndpoints",
      api.listVpcEndpoints
    )(request.buildAwsValue())
      .map(zio.aws.opensearch.model.ListVpcEndpointsResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcEndpoint(
        request: zio.aws.opensearch.model.DeleteVpcEndpointRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DeleteVpcEndpointResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteVpcEndpointRequest, DeleteVpcEndpointResponse](
        "deleteVpcEndpoint",
        api.deleteVpcEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.DeleteVpcEndpointResponse.wrap)
        .provideEnvironment(r)
    def createVpcEndpoint(
        request: zio.aws.opensearch.model.CreateVpcEndpointRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.CreateVpcEndpointResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateVpcEndpointRequest, CreateVpcEndpointResponse](
        "createVpcEndpoint",
        api.createVpcEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.CreateVpcEndpointResponse.wrap)
        .provideEnvironment(r)
    def cancelServiceSoftwareUpdate(
        request: zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelServiceSoftwareUpdateRequest,
      CancelServiceSoftwareUpdateResponse
    ]("cancelServiceSoftwareUpdate", api.cancelServiceSoftwareUpdate)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.wrap)
      .provideEnvironment(r)
    def describeDomainConfig(
        request: zio.aws.opensearch.model.DescribeDomainConfigRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeDomainConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDomainConfigRequest,
      DescribeDomainConfigResponse
    ]("describeDomainConfig", api.describeDomainConfig)(request.buildAwsValue())
      .map(zio.aws.opensearch.model.DescribeDomainConfigResponse.wrap)
      .provideEnvironment(r)
    def describeDomains(
        request: zio.aws.opensearch.model.DescribeDomainsRequest
    ): IO[AwsError, zio.aws.opensearch.model.DescribeDomainsResponse.ReadOnly] =
      asyncRequestResponse[DescribeDomainsRequest, DescribeDomainsResponse](
        "describeDomains",
        api.describeDomains
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.DescribeDomainsResponse.wrap)
        .provideEnvironment(r)
    def describeDomainAutoTunes(
        request: zio.aws.opensearch.model.DescribeDomainAutoTunesRequest
    ): ZStream[Any, AwsError, zio.aws.opensearch.model.AutoTune.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeDomainAutoTunesRequest,
        DescribeDomainAutoTunesResponse,
        AutoTune
      ](
        "describeDomainAutoTunes",
        api.describeDomainAutoTunes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.autoTunes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.opensearch.model.AutoTune.wrap(item))
        .provideEnvironment(r)
    def describeDomainAutoTunesPaginated(
        request: zio.aws.opensearch.model.DescribeDomainAutoTunesRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDomainAutoTunesRequest,
      DescribeDomainAutoTunesResponse
    ]("describeDomainAutoTunes", api.describeDomainAutoTunes)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.wrap)
      .provideEnvironment(r)
    def listInstanceTypeDetails(
        request: zio.aws.opensearch.model.ListInstanceTypeDetailsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListInstanceTypeDetailsRequest,
      ListInstanceTypeDetailsResponse,
      InstanceTypeDetails
    ](
      "listInstanceTypeDetails",
      api.listInstanceTypeDetails,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instanceTypeDetails().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.InstanceTypeDetails.wrap(item))
      .provideEnvironment(r)
    def listInstanceTypeDetailsPaginated(
        request: zio.aws.opensearch.model.ListInstanceTypeDetailsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListInstanceTypeDetailsRequest,
      ListInstanceTypeDetailsResponse
    ]("listInstanceTypeDetails", api.listInstanceTypeDetails)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.wrap)
      .provideEnvironment(r)
    def updatePackage(
        request: zio.aws.opensearch.model.UpdatePackageRequest
    ): IO[AwsError, zio.aws.opensearch.model.UpdatePackageResponse.ReadOnly] =
      asyncRequestResponse[UpdatePackageRequest, UpdatePackageResponse](
        "updatePackage",
        api.updatePackage
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.UpdatePackageResponse.wrap)
        .provideEnvironment(r)
    def deletePackage(
        request: zio.aws.opensearch.model.DeletePackageRequest
    ): IO[AwsError, zio.aws.opensearch.model.DeletePackageResponse.ReadOnly] =
      asyncRequestResponse[DeletePackageRequest, DeletePackageResponse](
        "deletePackage",
        api.deletePackage
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.DeletePackageResponse.wrap)
        .provideEnvironment(r)
    def deleteDomain(
        request: zio.aws.opensearch.model.DeleteDomainRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[DeleteDomainRequest, DeleteDomainResponse](
        "deleteDomain",
        api.deleteDomain
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.DeleteDomainResponse.wrap)
        .provideEnvironment(r)
    def describeInstanceTypeLimits(
        request: zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceTypeLimitsRequest,
      DescribeInstanceTypeLimitsResponse
    ]("describeInstanceTypeLimits", api.describeInstanceTypeLimits)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.wrap)
      .provideEnvironment(r)
    def acceptInboundConnection(
        request: zio.aws.opensearch.model.AcceptInboundConnectionRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.AcceptInboundConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptInboundConnectionRequest,
      AcceptInboundConnectionResponse
    ]("acceptInboundConnection", api.acceptInboundConnection)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.AcceptInboundConnectionResponse.wrap)
      .provideEnvironment(r)
    def describeVpcEndpoints(
        request: zio.aws.opensearch.model.DescribeVpcEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeVpcEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcEndpointsRequest,
      DescribeVpcEndpointsResponse
    ]("describeVpcEndpoints", api.describeVpcEndpoints)(request.buildAwsValue())
      .map(zio.aws.opensearch.model.DescribeVpcEndpointsResponse.wrap)
      .provideEnvironment(r)
    def deleteInboundConnection(
        request: zio.aws.opensearch.model.DeleteInboundConnectionRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DeleteInboundConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteInboundConnectionRequest,
      DeleteInboundConnectionResponse
    ]("deleteInboundConnection", api.deleteInboundConnection)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.DeleteInboundConnectionResponse.wrap)
      .provideEnvironment(r)
    def describeDomainHealth(
        request: zio.aws.opensearch.model.DescribeDomainHealthRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeDomainHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDomainHealthRequest,
      DescribeDomainHealthResponse
    ]("describeDomainHealth", api.describeDomainHealth)(request.buildAwsValue())
      .map(zio.aws.opensearch.model.DescribeDomainHealthResponse.wrap)
      .provideEnvironment(r)
    def purchaseReservedInstanceOffering(
        request: zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.ReadOnly
    ] = asyncRequestResponse[
      PurchaseReservedInstanceOfferingRequest,
      PurchaseReservedInstanceOfferingResponse
    ]("purchaseReservedInstanceOffering", api.purchaseReservedInstanceOffering)(
      request.buildAwsValue()
    ).map(
      zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.wrap
    ).provideEnvironment(r)
    def getUpgradeStatus(
        request: zio.aws.opensearch.model.GetUpgradeStatusRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.GetUpgradeStatusResponse.ReadOnly
    ] = asyncRequestResponse[GetUpgradeStatusRequest, GetUpgradeStatusResponse](
      "getUpgradeStatus",
      api.getUpgradeStatus
    )(request.buildAwsValue())
      .map(zio.aws.opensearch.model.GetUpgradeStatusResponse.wrap)
      .provideEnvironment(r)
    def listDomainNames(
        request: zio.aws.opensearch.model.ListDomainNamesRequest
    ): IO[AwsError, zio.aws.opensearch.model.ListDomainNamesResponse.ReadOnly] =
      asyncRequestResponse[ListDomainNamesRequest, ListDomainNamesResponse](
        "listDomainNames",
        api.listDomainNames
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.ListDomainNamesResponse.wrap)
        .provideEnvironment(r)
    def rejectInboundConnection(
        request: zio.aws.opensearch.model.RejectInboundConnectionRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.RejectInboundConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      RejectInboundConnectionRequest,
      RejectInboundConnectionResponse
    ]("rejectInboundConnection", api.rejectInboundConnection)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.RejectInboundConnectionResponse.wrap)
      .provideEnvironment(r)
    def authorizeVpcEndpointAccess(
        request: zio.aws.opensearch.model.AuthorizeVpcEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      AuthorizeVpcEndpointAccessRequest,
      AuthorizeVpcEndpointAccessResponse
    ]("authorizeVpcEndpointAccess", api.authorizeVpcEndpointAccess)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def listScheduledActions(
        request: zio.aws.opensearch.model.ListScheduledActionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.ScheduledAction.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListScheduledActionsRequest,
      ListScheduledActionsResponse,
      ScheduledAction
    ](
      "listScheduledActions",
      api.listScheduledActions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scheduledActions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.ScheduledAction.wrap(item))
      .provideEnvironment(r)
    def listScheduledActionsPaginated(
        request: zio.aws.opensearch.model.ListScheduledActionsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.ListScheduledActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListScheduledActionsRequest,
      ListScheduledActionsResponse
    ]("listScheduledActions", api.listScheduledActions)(request.buildAwsValue())
      .map(zio.aws.opensearch.model.ListScheduledActionsResponse.wrap)
      .provideEnvironment(r)
    def describeReservedInstanceOfferings(
        request: zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeReservedInstanceOfferingsRequest,
      DescribeReservedInstanceOfferingsResponse,
      ReservedInstanceOffering
    ](
      "describeReservedInstanceOfferings",
      api.describeReservedInstanceOfferings,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.reservedInstanceOfferings().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.opensearch.model.ReservedInstanceOffering.wrap(item))
      .provideEnvironment(r)
    def describeReservedInstanceOfferingsPaginated(
        request: zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReservedInstanceOfferingsRequest,
      DescribeReservedInstanceOfferingsResponse
    ](
      "describeReservedInstanceOfferings",
      api.describeReservedInstanceOfferings
    )(request.buildAwsValue())
      .map(
        zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.wrap
      )
      .provideEnvironment(r)
    def updateVpcEndpoint(
        request: zio.aws.opensearch.model.UpdateVpcEndpointRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.UpdateVpcEndpointResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateVpcEndpointRequest, UpdateVpcEndpointResponse](
        "updateVpcEndpoint",
        api.updateVpcEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.opensearch.model.UpdateVpcEndpointResponse.wrap)
        .provideEnvironment(r)
    def updateScheduledAction(
        request: zio.aws.opensearch.model.UpdateScheduledActionRequest
    ): IO[
      AwsError,
      zio.aws.opensearch.model.UpdateScheduledActionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateScheduledActionRequest,
      UpdateScheduledActionResponse
    ]("updateScheduledAction", api.updateScheduledAction)(
      request.buildAwsValue()
    ).map(zio.aws.opensearch.model.UpdateScheduledActionResponse.wrap)
      .provideEnvironment(r)
  }
  def describeDryRunProgress(
      request: zio.aws.opensearch.model.DescribeDryRunProgressRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeDryRunProgressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDryRunProgress(request))
  def describePackages(
      request: zio.aws.opensearch.model.DescribePackagesRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.PackageDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.describePackages(request))
  def describePackagesPaginated(
      request: zio.aws.opensearch.model.DescribePackagesRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribePackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePackagesPaginated(request))
  def startServiceSoftwareUpdate(
      request: zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startServiceSoftwareUpdate(request))
  def getCompatibleVersions(
      request: zio.aws.opensearch.model.GetCompatibleVersionsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.GetCompatibleVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCompatibleVersions(request))
  def listVpcEndpointAccess(
      request: zio.aws.opensearch.model.ListVpcEndpointAccessRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly
  ] = ZStream.serviceWithStream(_.listVpcEndpointAccess(request))
  def listVpcEndpointAccessPaginated(
      request: zio.aws.opensearch.model.ListVpcEndpointAccessRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListVpcEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVpcEndpointAccessPaginated(request))
  def associatePackage(
      request: zio.aws.opensearch.model.AssociatePackageRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.AssociatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associatePackage(request))
  def listVpcEndpointsForDomain(
      request: zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listVpcEndpointsForDomain(request))
  def listVpcEndpointsForDomainPaginated(
      request: zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVpcEndpointsForDomainPaginated(request))
  def describeDomain(
      request: zio.aws.opensearch.model.DescribeDomainRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomain(request))
  def createPackage(
      request: zio.aws.opensearch.model.CreatePackageRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.CreatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPackage(request))
  def listTags(request: zio.aws.opensearch.model.ListTagsRequest): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTags(request))
  def deleteOutboundConnection(
      request: zio.aws.opensearch.model.DeleteOutboundConnectionRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DeleteOutboundConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteOutboundConnection(request))
  def addTags(
      request: zio.aws.opensearch.model.AddTagsRequest
  ): ZIO[zio.aws.opensearch.OpenSearch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTags(request))
  def dissociatePackage(
      request: zio.aws.opensearch.model.DissociatePackageRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DissociatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.dissociatePackage(request))
  def updateDomainConfig(
      request: zio.aws.opensearch.model.UpdateDomainConfigRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.UpdateDomainConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomainConfig(request))
  def describeReservedInstances(
      request: zio.aws.opensearch.model.DescribeReservedInstancesRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ReservedInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedInstances(request))
  def describeReservedInstancesPaginated(
      request: zio.aws.opensearch.model.DescribeReservedInstancesRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeReservedInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedInstancesPaginated(request))
  def describeDomainNodes(
      request: zio.aws.opensearch.model.DescribeDomainNodesRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeDomainNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomainNodes(request))
  def listDomainsForPackage(
      request: zio.aws.opensearch.model.ListDomainsForPackageRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listDomainsForPackage(request))
  def listDomainsForPackagePaginated(
      request: zio.aws.opensearch.model.ListDomainsForPackageRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListDomainsForPackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainsForPackagePaginated(request))
  def createOutboundConnection(
      request: zio.aws.opensearch.model.CreateOutboundConnectionRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.CreateOutboundConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOutboundConnection(request))
  def upgradeDomain(
      request: zio.aws.opensearch.model.UpgradeDomainRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.UpgradeDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.upgradeDomain(request))
  def describeOutboundConnections(
      request: zio.aws.opensearch.model.DescribeOutboundConnectionsRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.OutboundConnection.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOutboundConnections(request))
  def describeOutboundConnectionsPaginated(
      request: zio.aws.opensearch.model.DescribeOutboundConnectionsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOutboundConnectionsPaginated(request))
  def describeDomainChangeProgress(
      request: zio.aws.opensearch.model.DescribeDomainChangeProgressRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomainChangeProgress(request))
  def removeTags(
      request: zio.aws.opensearch.model.RemoveTagsRequest
  ): ZIO[zio.aws.opensearch.OpenSearch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTags(request))
  def getUpgradeHistory(
      request: zio.aws.opensearch.model.GetUpgradeHistoryRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.UpgradeHistory.ReadOnly
  ] = ZStream.serviceWithStream(_.getUpgradeHistory(request))
  def getUpgradeHistoryPaginated(
      request: zio.aws.opensearch.model.GetUpgradeHistoryRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.GetUpgradeHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUpgradeHistoryPaginated(request))
  def createDomain(request: zio.aws.opensearch.model.CreateDomainRequest): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.CreateDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomain(request))
  def revokeVpcEndpointAccess(
      request: zio.aws.opensearch.model.RevokeVpcEndpointAccessRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.RevokeVpcEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeVpcEndpointAccess(request))
  def listPackagesForDomain(
      request: zio.aws.opensearch.model.ListPackagesForDomainRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackagesForDomain(request))
  def listPackagesForDomainPaginated(
      request: zio.aws.opensearch.model.ListPackagesForDomainRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListPackagesForDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackagesForDomainPaginated(request))
  def describeInboundConnections(
      request: zio.aws.opensearch.model.DescribeInboundConnectionsRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.InboundConnection.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInboundConnections(request))
  def describeInboundConnectionsPaginated(
      request: zio.aws.opensearch.model.DescribeInboundConnectionsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeInboundConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInboundConnectionsPaginated(request))
  def listVersions(
      request: zio.aws.opensearch.model.ListVersionsRequest
  ): ZStream[zio.aws.opensearch.OpenSearch, AwsError, VersionString] =
    ZStream.serviceWithStream(_.listVersions(request))
  def listVersionsPaginated(
      request: zio.aws.opensearch.model.ListVersionsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVersionsPaginated(request))
  def getPackageVersionHistory(
      request: zio.aws.opensearch.model.GetPackageVersionHistoryRequest
  ): ZIO[zio.aws.opensearch.OpenSearch, AwsError, StreamingOutputResult[
    Any,
    zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly,
    zio.aws.opensearch.model.PackageVersionHistory.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getPackageVersionHistory(request))
  def getPackageVersionHistoryPaginated(
      request: zio.aws.opensearch.model.GetPackageVersionHistoryRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPackageVersionHistoryPaginated(request))
  def listVpcEndpoints(
      request: zio.aws.opensearch.model.ListVpcEndpointsRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listVpcEndpoints(request))
  def listVpcEndpointsPaginated(
      request: zio.aws.opensearch.model.ListVpcEndpointsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListVpcEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVpcEndpointsPaginated(request))
  def deleteVpcEndpoint(
      request: zio.aws.opensearch.model.DeleteVpcEndpointRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DeleteVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcEndpoint(request))
  def createVpcEndpoint(
      request: zio.aws.opensearch.model.CreateVpcEndpointRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.CreateVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcEndpoint(request))
  def cancelServiceSoftwareUpdate(
      request: zio.aws.opensearch.model.CancelServiceSoftwareUpdateRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelServiceSoftwareUpdate(request))
  def describeDomainConfig(
      request: zio.aws.opensearch.model.DescribeDomainConfigRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeDomainConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomainConfig(request))
  def describeDomains(
      request: zio.aws.opensearch.model.DescribeDomainsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomains(request))
  def describeDomainAutoTunes(
      request: zio.aws.opensearch.model.DescribeDomainAutoTunesRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.AutoTune.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDomainAutoTunes(request))
  def describeDomainAutoTunesPaginated(
      request: zio.aws.opensearch.model.DescribeDomainAutoTunesRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomainAutoTunesPaginated(request))
  def listInstanceTypeDetails(
      request: zio.aws.opensearch.model.ListInstanceTypeDetailsRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstanceTypeDetails(request))
  def listInstanceTypeDetailsPaginated(
      request: zio.aws.opensearch.model.ListInstanceTypeDetailsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceTypeDetailsPaginated(request))
  def updatePackage(
      request: zio.aws.opensearch.model.UpdatePackageRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.UpdatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePackage(request))
  def deletePackage(
      request: zio.aws.opensearch.model.DeletePackageRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DeletePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePackage(request))
  def deleteDomain(
      request: zio.aws.opensearch.model.DeleteDomainRequest
  ): ZIO[zio.aws.opensearch.OpenSearch, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteDomain(request))
  def describeInstanceTypeLimits(
      request: zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceTypeLimits(request))
  def acceptInboundConnection(
      request: zio.aws.opensearch.model.AcceptInboundConnectionRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.AcceptInboundConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptInboundConnection(request))
  def describeVpcEndpoints(
      request: zio.aws.opensearch.model.DescribeVpcEndpointsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeVpcEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcEndpoints(request))
  def deleteInboundConnection(
      request: zio.aws.opensearch.model.DeleteInboundConnectionRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DeleteInboundConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInboundConnection(request))
  def describeDomainHealth(
      request: zio.aws.opensearch.model.DescribeDomainHealthRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeDomainHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomainHealth(request))
  def purchaseReservedInstanceOffering(
      request: zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseReservedInstanceOffering(request))
  def getUpgradeStatus(
      request: zio.aws.opensearch.model.GetUpgradeStatusRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.GetUpgradeStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUpgradeStatus(request))
  def listDomainNames(
      request: zio.aws.opensearch.model.ListDomainNamesRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListDomainNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainNames(request))
  def rejectInboundConnection(
      request: zio.aws.opensearch.model.RejectInboundConnectionRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.RejectInboundConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectInboundConnection(request))
  def authorizeVpcEndpointAccess(
      request: zio.aws.opensearch.model.AuthorizeVpcEndpointAccessRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.AuthorizeVpcEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeVpcEndpointAccess(request))
  def listScheduledActions(
      request: zio.aws.opensearch.model.ListScheduledActionsRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ScheduledAction.ReadOnly
  ] = ZStream.serviceWithStream(_.listScheduledActions(request))
  def listScheduledActionsPaginated(
      request: zio.aws.opensearch.model.ListScheduledActionsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ListScheduledActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listScheduledActionsPaginated(request))
  def describeReservedInstanceOfferings(
      request: zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest
  ): ZStream[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedInstanceOfferings(request))
  def describeReservedInstanceOfferingsPaginated(
      request: zio.aws.opensearch.model.DescribeReservedInstanceOfferingsRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedInstanceOfferingsPaginated(request))
  def updateVpcEndpoint(
      request: zio.aws.opensearch.model.UpdateVpcEndpointRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.UpdateVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVpcEndpoint(request))
  def updateScheduledAction(
      request: zio.aws.opensearch.model.UpdateScheduledActionRequest
  ): ZIO[
    zio.aws.opensearch.OpenSearch,
    AwsError,
    zio.aws.opensearch.model.UpdateScheduledActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateScheduledAction(request))
}
