package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{VersionString, DomainName}
import scala.jdk.CollectionConverters._
final case class UpgradeDomainRequest(
    domainName: DomainName,
    targetVersion: VersionString,
    performCheckOnly: Optional[Boolean] = Optional.Absent,
    advancedOptions: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest = {
    import UpgradeDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .targetVersion(VersionString.unwrap(targetVersion): java.lang.String)
      .optionallyWith(performCheckOnly.map(value => value: java.lang.Boolean))(
        _.performCheckOnly
      )
      .optionallyWith(
        advancedOptions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.advancedOptions)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpgradeDomainRequest.ReadOnly =
    zio.aws.opensearch.model.UpgradeDomainRequest.wrap(buildAwsValue())
}
object UpgradeDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpgradeDomainRequest =
      zio.aws.opensearch.model.UpgradeDomainRequest(
        domainName,
        targetVersion,
        performCheckOnly.map(value => value),
        advancedOptions.map(value => value)
      )
    def domainName: DomainName
    def targetVersion: VersionString
    def performCheckOnly: Optional[Boolean]
    def advancedOptions: Optional[Map[String, String]]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getTargetVersion: ZIO[Any, Nothing, VersionString] =
      ZIO.succeed(targetVersion)
    def getPerformCheckOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performCheckOnly", performCheckOnly)
    def getAdvancedOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("advancedOptions", advancedOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest
  ) extends zio.aws.opensearch.model.UpgradeDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val targetVersion: VersionString =
      zio.aws.opensearch.model.primitives.VersionString(impl.targetVersion())
    override val performCheckOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performCheckOnly())
      .map(value => value: Boolean)
    override val advancedOptions: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest
  ): zio.aws.opensearch.model.UpgradeDomainRequest.ReadOnly = new Wrapper(impl)
}
