package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait TLSSecurityPolicy {
  def unwrap: software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy
}
object TLSSecurityPolicy {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy
  ): zio.aws.opensearch.model.TLSSecurityPolicy = value match {
    case software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_0_2019_07 =>
      val r = `Policy-Min-TLS-1-0-2019-07`
      r
    case software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_2_2019_07 =>
      val r = `Policy-Min-TLS-1-2-2019-07`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.TLSSecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy =
      software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object `Policy-Min-TLS-1-0-2019-07`
      extends zio.aws.opensearch.model.TLSSecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy =
      software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_0_2019_07
  }
  case object `Policy-Min-TLS-1-2-2019-07`
      extends zio.aws.opensearch.model.TLSSecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy =
      software.amazon.awssdk.services.opensearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_2_2019_07
  }
}
