package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait OpenSearchWarmPartitionInstanceType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType
}
object OpenSearchWarmPartitionInstanceType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType
  ): zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType =
    value match {
      case software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType.ULTRAWARM1_MEDIUM_SEARCH =>
        val r = `ultrawarm1.medium.search`
        r
      case software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType.ULTRAWARM1_LARGE_SEARCH =>
        val r = `ultrawarm1.large.search`
        r
      case software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType.ULTRAWARM1_XLARGE_SEARCH =>
        val r = `ultrawarm1.xlarge.search`
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ultrawarm1.medium.search`
      extends zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType.ULTRAWARM1_MEDIUM_SEARCH
  }
  case object `ultrawarm1.large.search`
      extends zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType.ULTRAWARM1_LARGE_SEARCH
  }
  case object `ultrawarm1.xlarge.search`
      extends zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType =
      software.amazon.awssdk.services.opensearch.model.OpenSearchWarmPartitionInstanceType.ULTRAWARM1_XLARGE_SEARCH
  }
}
