package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.ConnectionStatusMessage
import scala.jdk.CollectionConverters._
final case class InboundConnectionStatus(
    statusCode: Optional[zio.aws.opensearch.model.InboundConnectionStatusCode] =
      Optional.Absent,
    message: Optional[ConnectionStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatus = {
    import InboundConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.InboundConnectionStatus
      .builder()
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        message.map(value =>
          ConnectionStatusMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.InboundConnectionStatus.ReadOnly =
    zio.aws.opensearch.model.InboundConnectionStatus.wrap(buildAwsValue())
}
object InboundConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.InboundConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.InboundConnectionStatus =
      zio.aws.opensearch.model.InboundConnectionStatus(
        statusCode.map(value => value),
        message.map(value => value)
      )
    def statusCode
        : Optional[zio.aws.opensearch.model.InboundConnectionStatusCode]
    def message: Optional[ConnectionStatusMessage]
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.InboundConnectionStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getMessage: ZIO[Any, AwsError, ConnectionStatusMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.InboundConnectionStatus
  ) extends zio.aws.opensearch.model.InboundConnectionStatus.ReadOnly {
    override val statusCode
        : Optional[zio.aws.opensearch.model.InboundConnectionStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.opensearch.model.InboundConnectionStatusCode.wrap(value)
        )
    override val message: Optional[ConnectionStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.opensearch.model.primitives.ConnectionStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.InboundConnectionStatus
  ): zio.aws.opensearch.model.InboundConnectionStatus.ReadOnly = new Wrapper(
    impl
  )
}
