package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{ErrorMessage, ErrorType}
import scala.jdk.CollectionConverters._
final case class ErrorDetails(
    errorType: Optional[ErrorType] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ErrorDetails
      .builder()
      .optionallyWith(
        errorType.map(value => ErrorType.unwrap(value): java.lang.String)
      )(_.errorType)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ErrorDetails.ReadOnly =
    zio.aws.opensearch.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ErrorDetails =
      zio.aws.opensearch.model.ErrorDetails(
        errorType.map(value => value),
        errorMessage.map(value => value)
      )
    def errorType: Optional[ErrorType]
    def errorMessage: Optional[ErrorMessage]
    def getErrorType: ZIO[Any, AwsError, ErrorType] =
      AwsError.unwrapOptionField("errorType", errorType)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ErrorDetails
  ) extends zio.aws.opensearch.model.ErrorDetails.ReadOnly {
    override val errorType: Optional[ErrorType] = zio.aws.core.internal
      .optionalFromNullable(impl.errorType())
      .map(value => zio.aws.opensearch.model.primitives.ErrorType(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.opensearch.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ErrorDetails
  ): zio.aws.opensearch.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
