package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.DurationValue
import scala.jdk.CollectionConverters._
final case class Duration(
    value: Optional[DurationValue] = Optional.Absent,
    unit: Optional[zio.aws.opensearch.model.TimeUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.Duration = {
    import Duration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.Duration
      .builder()
      .optionallyWith(
        value.map(value => DurationValue.unwrap(value): java.lang.Long)
      )(_.value)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.Duration.ReadOnly =
    zio.aws.opensearch.model.Duration.wrap(buildAwsValue())
}
object Duration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.Duration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.Duration = zio.aws.opensearch.model
      .Duration(value.map(value => value), unit.map(value => value))
    def value: Optional[DurationValue]
    def unit: Optional[zio.aws.opensearch.model.TimeUnit]
    def getValue: ZIO[Any, AwsError, DurationValue] =
      AwsError.unwrapOptionField("value", value)
    def getUnit: ZIO[Any, AwsError, zio.aws.opensearch.model.TimeUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.Duration
  ) extends zio.aws.opensearch.model.Duration.ReadOnly {
    override val value: Optional[DurationValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.opensearch.model.primitives.DurationValue(value))
    override val unit: Optional[zio.aws.opensearch.model.TimeUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.opensearch.model.TimeUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.Duration
  ): zio.aws.opensearch.model.Duration.ReadOnly = new Wrapper(impl)
}
