package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{ConnectionId, ConnectionAlias}
import scala.jdk.CollectionConverters._
final case class CreateOutboundConnectionResponse(
    localDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer
    ] = Optional.Absent,
    remoteDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer
    ] = Optional.Absent,
    connectionAlias: Optional[ConnectionAlias] = Optional.Absent,
    connectionStatus: Optional[
      zio.aws.opensearch.model.OutboundConnectionStatus
    ] = Optional.Absent,
    connectionId: Optional[ConnectionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse = {
    import CreateOutboundConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse
      .builder()
      .optionallyWith(localDomainInfo.map(value => value.buildAwsValue()))(
        _.localDomainInfo
      )
      .optionallyWith(remoteDomainInfo.map(value => value.buildAwsValue()))(
        _.remoteDomainInfo
      )
      .optionallyWith(
        connectionAlias.map(value =>
          ConnectionAlias.unwrap(value): java.lang.String
        )
      )(_.connectionAlias)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.CreateOutboundConnectionResponse.ReadOnly =
    zio.aws.opensearch.model.CreateOutboundConnectionResponse
      .wrap(buildAwsValue())
}
object CreateOutboundConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CreateOutboundConnectionResponse =
      zio.aws.opensearch.model.CreateOutboundConnectionResponse(
        localDomainInfo.map(value => value.asEditable),
        remoteDomainInfo.map(value => value.asEditable),
        connectionAlias.map(value => value),
        connectionStatus.map(value => value.asEditable),
        connectionId.map(value => value)
      )
    def localDomainInfo
        : Optional[zio.aws.opensearch.model.DomainInformationContainer.ReadOnly]
    def remoteDomainInfo
        : Optional[zio.aws.opensearch.model.DomainInformationContainer.ReadOnly]
    def connectionAlias: Optional[ConnectionAlias]
    def connectionStatus
        : Optional[zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly]
    def connectionId: Optional[ConnectionId]
    def getLocalDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = AwsError.unwrapOptionField("localDomainInfo", localDomainInfo)
    def getRemoteDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = AwsError.unwrapOptionField("remoteDomainInfo", remoteDomainInfo)
    def getConnectionAlias: ZIO[Any, AwsError, ConnectionAlias] =
      AwsError.unwrapOptionField("connectionAlias", connectionAlias)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse
  ) extends zio.aws.opensearch.model.CreateOutboundConnectionResponse.ReadOnly {
    override val localDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.localDomainInfo())
      .map(value =>
        zio.aws.opensearch.model.DomainInformationContainer.wrap(value)
      )
    override val remoteDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteDomainInfo())
      .map(value =>
        zio.aws.opensearch.model.DomainInformationContainer.wrap(value)
      )
    override val connectionAlias: Optional[ConnectionAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionAlias())
        .map(value =>
          zio.aws.opensearch.model.primitives.ConnectionAlias(value)
        )
    override val connectionStatus
        : Optional[zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStatus())
        .map(value =>
          zio.aws.opensearch.model.OutboundConnectionStatus.wrap(value)
        )
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.opensearch.model.primitives.ConnectionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse
  ): zio.aws.opensearch.model.CreateOutboundConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
