package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{UIntValue, UpdateTimestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AutoTuneStatus(
    creationDate: UpdateTimestamp,
    updateDate: UpdateTimestamp,
    updateVersion: Optional[UIntValue] = Optional.Absent,
    state: zio.aws.opensearch.model.AutoTuneState,
    errorMessage: Optional[String] = Optional.Absent,
    pendingDeletion: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AutoTuneStatus = {
    import AutoTuneStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AutoTuneStatus
      .builder()
      .creationDate(UpdateTimestamp.unwrap(creationDate): Instant)
      .updateDate(UpdateTimestamp.unwrap(updateDate): Instant)
      .optionallyWith(
        updateVersion.map(value => UIntValue.unwrap(value): Integer)
      )(_.updateVersion)
      .state(state.unwrap)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(pendingDeletion.map(value => value: java.lang.Boolean))(
        _.pendingDeletion
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AutoTuneStatus.ReadOnly =
    zio.aws.opensearch.model.AutoTuneStatus.wrap(buildAwsValue())
}
object AutoTuneStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AutoTuneStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AutoTuneStatus =
      zio.aws.opensearch.model.AutoTuneStatus(
        creationDate,
        updateDate,
        updateVersion.map(value => value),
        state,
        errorMessage.map(value => value),
        pendingDeletion.map(value => value)
      )
    def creationDate: UpdateTimestamp
    def updateDate: UpdateTimestamp
    def updateVersion: Optional[UIntValue]
    def state: zio.aws.opensearch.model.AutoTuneState
    def errorMessage: Optional[String]
    def pendingDeletion: Optional[Boolean]
    def getCreationDate: ZIO[Any, Nothing, UpdateTimestamp] =
      ZIO.succeed(creationDate)
    def getUpdateDate: ZIO[Any, Nothing, UpdateTimestamp] =
      ZIO.succeed(updateDate)
    def getUpdateVersion: ZIO[Any, AwsError, UIntValue] =
      AwsError.unwrapOptionField("updateVersion", updateVersion)
    def getState: ZIO[Any, Nothing, zio.aws.opensearch.model.AutoTuneState] =
      ZIO.succeed(state)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getPendingDeletion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pendingDeletion", pendingDeletion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneStatus
  ) extends zio.aws.opensearch.model.AutoTuneStatus.ReadOnly {
    override val creationDate: UpdateTimestamp =
      zio.aws.opensearch.model.primitives.UpdateTimestamp(impl.creationDate())
    override val updateDate: UpdateTimestamp =
      zio.aws.opensearch.model.primitives.UpdateTimestamp(impl.updateDate())
    override val updateVersion: Optional[UIntValue] = zio.aws.core.internal
      .optionalFromNullable(impl.updateVersion())
      .map(value => zio.aws.opensearch.model.primitives.UIntValue(value))
    override val state: zio.aws.opensearch.model.AutoTuneState =
      zio.aws.opensearch.model.AutoTuneState.wrap(impl.state())
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val pendingDeletion: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingDeletion())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneStatus
  ): zio.aws.opensearch.model.AutoTuneStatus.ReadOnly = new Wrapper(impl)
}
