package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartServiceSoftwareUpdateResponse(
    serviceSoftwareOptions: Optional[
      zio.aws.opensearch.model.ServiceSoftwareOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse = {
    import StartServiceSoftwareUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse
      .builder()
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.ReadOnly =
    zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse
      .wrap(buildAwsValue())
}
object StartServiceSoftwareUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse =
      zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse(
        serviceSoftwareOptions.map(value => value.asEditable)
      )
    def serviceSoftwareOptions
        : Optional[zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly]
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse
  ) extends zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.ReadOnly {
    override val serviceSoftwareOptions
        : Optional[zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSoftwareOptions())
        .map(value =>
          zio.aws.opensearch.model.ServiceSoftwareOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse
  ): zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.ReadOnly =
    new Wrapper(impl)
}
