package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{IntegerClass, BackendRole, Username}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SAMLOptionsInput(
    enabled: Optional[Boolean] = Optional.Absent,
    idp: Optional[zio.aws.opensearch.model.SAMLIdp] = Optional.Absent,
    masterUserName: Optional[Username] = Optional.Absent,
    masterBackendRole: Optional[BackendRole] = Optional.Absent,
    subjectKey: Optional[String] = Optional.Absent,
    rolesKey: Optional[String] = Optional.Absent,
    sessionTimeoutMinutes: Optional[IntegerClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.SAMLOptionsInput = {
    import SAMLOptionsInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.SAMLOptionsInput
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(idp.map(value => value.buildAwsValue()))(_.idp)
      .optionallyWith(
        masterUserName.map(value => Username.unwrap(value): java.lang.String)
      )(_.masterUserName)
      .optionallyWith(
        masterBackendRole.map(value =>
          BackendRole.unwrap(value): java.lang.String
        )
      )(_.masterBackendRole)
      .optionallyWith(subjectKey.map(value => value: java.lang.String))(
        _.subjectKey
      )
      .optionallyWith(rolesKey.map(value => value: java.lang.String))(
        _.rolesKey
      )
      .optionallyWith(
        sessionTimeoutMinutes.map(value => IntegerClass.unwrap(value): Integer)
      )(_.sessionTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.SAMLOptionsInput.ReadOnly =
    zio.aws.opensearch.model.SAMLOptionsInput.wrap(buildAwsValue())
}
object SAMLOptionsInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.SAMLOptionsInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.SAMLOptionsInput =
      zio.aws.opensearch.model.SAMLOptionsInput(
        enabled.map(value => value),
        idp.map(value => value.asEditable),
        masterUserName.map(value => value),
        masterBackendRole.map(value => value),
        subjectKey.map(value => value),
        rolesKey.map(value => value),
        sessionTimeoutMinutes.map(value => value)
      )
    def enabled: Optional[Boolean]
    def idp: Optional[zio.aws.opensearch.model.SAMLIdp.ReadOnly]
    def masterUserName: Optional[Username]
    def masterBackendRole: Optional[BackendRole]
    def subjectKey: Optional[String]
    def rolesKey: Optional[String]
    def sessionTimeoutMinutes: Optional[IntegerClass]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIdp: ZIO[Any, AwsError, zio.aws.opensearch.model.SAMLIdp.ReadOnly] =
      AwsError.unwrapOptionField("idp", idp)
    def getMasterUserName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("masterUserName", masterUserName)
    def getMasterBackendRole: ZIO[Any, AwsError, BackendRole] =
      AwsError.unwrapOptionField("masterBackendRole", masterBackendRole)
    def getSubjectKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subjectKey", subjectKey)
    def getRolesKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rolesKey", rolesKey)
    def getSessionTimeoutMinutes: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("sessionTimeoutMinutes", sessionTimeoutMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.SAMLOptionsInput
  ) extends zio.aws.opensearch.model.SAMLOptionsInput.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val idp: Optional[zio.aws.opensearch.model.SAMLIdp.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idp())
        .map(value => zio.aws.opensearch.model.SAMLIdp.wrap(value))
    override val masterUserName: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserName())
      .map(value => zio.aws.opensearch.model.primitives.Username(value))
    override val masterBackendRole: Optional[BackendRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterBackendRole())
        .map(value => zio.aws.opensearch.model.primitives.BackendRole(value))
    override val subjectKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectKey())
      .map(value => value: String)
    override val rolesKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rolesKey())
      .map(value => value: String)
    override val sessionTimeoutMinutes: Optional[IntegerClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionTimeoutMinutes())
        .map(value => zio.aws.opensearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.SAMLOptionsInput
  ): zio.aws.opensearch.model.SAMLOptionsInput.ReadOnly = new Wrapper(impl)
}
