package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceLimits(
    instanceCountLimits: Optional[
      zio.aws.opensearch.model.InstanceCountLimits
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.InstanceLimits = {
    import InstanceLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.InstanceLimits
      .builder()
      .optionallyWith(instanceCountLimits.map(value => value.buildAwsValue()))(
        _.instanceCountLimits
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.InstanceLimits.ReadOnly =
    zio.aws.opensearch.model.InstanceLimits.wrap(buildAwsValue())
}
object InstanceLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.InstanceLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.InstanceLimits =
      zio.aws.opensearch.model
        .InstanceLimits(instanceCountLimits.map(value => value.asEditable))
    def instanceCountLimits
        : Optional[zio.aws.opensearch.model.InstanceCountLimits.ReadOnly]
    def getInstanceCountLimits: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.InstanceCountLimits.ReadOnly
    ] = AwsError.unwrapOptionField("instanceCountLimits", instanceCountLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.InstanceLimits
  ) extends zio.aws.opensearch.model.InstanceLimits.ReadOnly {
    override val instanceCountLimits
        : Optional[zio.aws.opensearch.model.InstanceCountLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCountLimits())
        .map(value => zio.aws.opensearch.model.InstanceCountLimits.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.InstanceLimits
  ): zio.aws.opensearch.model.InstanceLimits.ReadOnly = new Wrapper(impl)
}
