package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EncryptionAtRestOptionsStatus(
    options: zio.aws.opensearch.model.EncryptionAtRestOptions,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptionsStatus = {
    import EncryptionAtRestOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.EncryptionAtRestOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.EncryptionAtRestOptionsStatus.wrap(buildAwsValue())
}
object EncryptionAtRestOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.EncryptionAtRestOptionsStatus =
      zio.aws.opensearch.model
        .EncryptionAtRestOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptionsStatus
  ) extends zio.aws.opensearch.model.EncryptionAtRestOptionsStatus.ReadOnly {
    override val options
        : zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly =
      zio.aws.opensearch.model.EncryptionAtRestOptions.wrap(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptionsStatus
  ): zio.aws.opensearch.model.EncryptionAtRestOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
