package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{VersionString, DomainName}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceTypeLimitsRequest(
    domainName: Optional[DomainName] = Optional.Absent,
    instanceType: zio.aws.opensearch.model.OpenSearchPartitionInstanceType,
    engineVersion: VersionString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest = {
    import DescribeInstanceTypeLimitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .instanceType(instanceType.unwrap)
      .engineVersion(VersionString.unwrap(engineVersion): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest
      .wrap(buildAwsValue())
}
object DescribeInstanceTypeLimitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest =
      zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest(
        domainName.map(value => value),
        instanceType,
        engineVersion
      )
    def domainName: Optional[DomainName]
    def instanceType: zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    def engineVersion: VersionString
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getInstanceType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = ZIO.succeed(instanceType)
    def getEngineVersion: ZIO[Any, Nothing, VersionString] =
      ZIO.succeed(engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest
  ) extends zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.opensearch.model.primitives.DomainName(value))
    override val instanceType
        : zio.aws.opensearch.model.OpenSearchPartitionInstanceType =
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
        .wrap(impl.instanceType())
    override val engineVersion: VersionString =
      zio.aws.opensearch.model.primitives.VersionString(impl.engineVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest
  ): zio.aws.opensearch.model.DescribeInstanceTypeLimitsRequest.ReadOnly =
    new Wrapper(impl)
}
