package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDomainResponse(
    domainStatus: zio.aws.opensearch.model.DomainStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse = {
    import DescribeDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse
      .builder()
      .domainStatus(domainStatus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DescribeDomainResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainResponse.wrap(buildAwsValue())
}
object DescribeDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainResponse =
      zio.aws.opensearch.model.DescribeDomainResponse(domainStatus.asEditable)
    def domainStatus: zio.aws.opensearch.model.DomainStatus.ReadOnly
    def getDomainStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.DomainStatus.ReadOnly] =
      ZIO.succeed(domainStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse
  ) extends zio.aws.opensearch.model.DescribeDomainResponse.ReadOnly {
    override val domainStatus: zio.aws.opensearch.model.DomainStatus.ReadOnly =
      zio.aws.opensearch.model.DomainStatus.wrap(impl.domainStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse
  ): zio.aws.opensearch.model.DescribeDomainResponse.ReadOnly = new Wrapper(
    impl
  )
}
