package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class DescribeDomainConfigRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest = {
    import DescribeDomainConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDomainConfigRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainConfigRequest.wrap(buildAwsValue())
}
object DescribeDomainConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainConfigRequest =
      zio.aws.opensearch.model.DescribeDomainConfigRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest
  ) extends zio.aws.opensearch.model.DescribeDomainConfigRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest
  ): zio.aws.opensearch.model.DescribeDomainConfigRequest.ReadOnly =
    new Wrapper(impl)
}
