package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ColdStorageOptions(enabled: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ColdStorageOptions = {
    import ColdStorageOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ColdStorageOptions
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ColdStorageOptions.ReadOnly =
    zio.aws.opensearch.model.ColdStorageOptions.wrap(buildAwsValue())
}
object ColdStorageOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ColdStorageOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ColdStorageOptions =
      zio.aws.opensearch.model.ColdStorageOptions(enabled)
    def enabled: Boolean
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ColdStorageOptions
  ) extends zio.aws.opensearch.model.ColdStorageOptions.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ColdStorageOptions
  ): zio.aws.opensearch.model.ColdStorageOptions.ReadOnly = new Wrapper(impl)
}
