package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{LimitValue, LimitName}
import scala.jdk.CollectionConverters._
final case class StorageTypeLimit(
    limitName: Optional[LimitName] = Optional.Absent,
    limitValues: Optional[Iterable[LimitValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.StorageTypeLimit = {
    import StorageTypeLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.StorageTypeLimit
      .builder()
      .optionallyWith(
        limitName.map(value => LimitName.unwrap(value): java.lang.String)
      )(_.limitName)
      .optionallyWith(
        limitValues.map(value =>
          value.map { item =>
            LimitValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.limitValues)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.StorageTypeLimit.ReadOnly =
    zio.aws.opensearch.model.StorageTypeLimit.wrap(buildAwsValue())
}
object StorageTypeLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.StorageTypeLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.StorageTypeLimit =
      zio.aws.opensearch.model.StorageTypeLimit(
        limitName.map(value => value),
        limitValues.map(value => value)
      )
    def limitName: Optional[LimitName]
    def limitValues: Optional[List[LimitValue]]
    def getLimitName: ZIO[Any, AwsError, LimitName] =
      AwsError.unwrapOptionField("limitName", limitName)
    def getLimitValues: ZIO[Any, AwsError, List[LimitValue]] =
      AwsError.unwrapOptionField("limitValues", limitValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.StorageTypeLimit
  ) extends zio.aws.opensearch.model.StorageTypeLimit.ReadOnly {
    override val limitName: Optional[LimitName] = zio.aws.core.internal
      .optionalFromNullable(impl.limitName())
      .map(value => zio.aws.opensearch.model.primitives.LimitName(value))
    override val limitValues: Optional[List[LimitValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.limitValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.primitives.LimitValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.StorageTypeLimit
  ): zio.aws.opensearch.model.StorageTypeLimit.ReadOnly = new Wrapper(impl)
}
