package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{ConnectionAlias, ConnectionId}
import scala.jdk.CollectionConverters._
final case class OutboundConnection(
    localDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer
    ] = Optional.Absent,
    remoteDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer
    ] = Optional.Absent,
    connectionId: Optional[ConnectionId] = Optional.Absent,
    connectionAlias: Optional[ConnectionAlias] = Optional.Absent,
    connectionStatus: Optional[
      zio.aws.opensearch.model.OutboundConnectionStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.OutboundConnection = {
    import OutboundConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.OutboundConnection
      .builder()
      .optionallyWith(localDomainInfo.map(value => value.buildAwsValue()))(
        _.localDomainInfo
      )
      .optionallyWith(remoteDomainInfo.map(value => value.buildAwsValue()))(
        _.remoteDomainInfo
      )
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        connectionAlias.map(value =>
          ConnectionAlias.unwrap(value): java.lang.String
        )
      )(_.connectionAlias)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.OutboundConnection.ReadOnly =
    zio.aws.opensearch.model.OutboundConnection.wrap(buildAwsValue())
}
object OutboundConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.OutboundConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.OutboundConnection =
      zio.aws.opensearch.model.OutboundConnection(
        localDomainInfo.map(value => value.asEditable),
        remoteDomainInfo.map(value => value.asEditable),
        connectionId.map(value => value),
        connectionAlias.map(value => value),
        connectionStatus.map(value => value.asEditable)
      )
    def localDomainInfo
        : Optional[zio.aws.opensearch.model.DomainInformationContainer.ReadOnly]
    def remoteDomainInfo
        : Optional[zio.aws.opensearch.model.DomainInformationContainer.ReadOnly]
    def connectionId: Optional[ConnectionId]
    def connectionAlias: Optional[ConnectionAlias]
    def connectionStatus
        : Optional[zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly]
    def getLocalDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = AwsError.unwrapOptionField("localDomainInfo", localDomainInfo)
    def getRemoteDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = AwsError.unwrapOptionField("remoteDomainInfo", remoteDomainInfo)
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getConnectionAlias: ZIO[Any, AwsError, ConnectionAlias] =
      AwsError.unwrapOptionField("connectionAlias", connectionAlias)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.OutboundConnection
  ) extends zio.aws.opensearch.model.OutboundConnection.ReadOnly {
    override val localDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.localDomainInfo())
      .map(value =>
        zio.aws.opensearch.model.DomainInformationContainer.wrap(value)
      )
    override val remoteDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteDomainInfo())
      .map(value =>
        zio.aws.opensearch.model.DomainInformationContainer.wrap(value)
      )
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.opensearch.model.primitives.ConnectionId(value))
    override val connectionAlias: Optional[ConnectionAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionAlias())
        .map(value =>
          zio.aws.opensearch.model.primitives.ConnectionAlias(value)
        )
    override val connectionStatus
        : Optional[zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStatus())
        .map(value =>
          zio.aws.opensearch.model.OutboundConnectionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.OutboundConnection
  ): zio.aws.opensearch.model.OutboundConnection.ReadOnly = new Wrapper(impl)
}
