package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.{DomainName, PackageID}
import scala.jdk.CollectionConverters._
final case class DissociatePackageRequest(
    packageID: PackageID,
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest = {
    import DissociatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DissociatePackageRequest.ReadOnly =
    zio.aws.opensearch.model.DissociatePackageRequest.wrap(buildAwsValue())
}
object DissociatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DissociatePackageRequest =
      zio.aws.opensearch.model.DissociatePackageRequest(packageID, domainName)
    def packageID: PackageID
    def domainName: DomainName
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest
  ) extends zio.aws.opensearch.model.DissociatePackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.opensearch.model.primitives.PackageID(impl.packageID())
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest
  ): zio.aws.opensearch.model.DissociatePackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
