package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class DescribeDomainsRequest(domainNames: Iterable[DomainName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest = {
    import DescribeDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest
      .builder()
      .domainNames(domainNames.map { item =>
        DomainName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DescribeDomainsRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainsRequest.wrap(buildAwsValue())
}
object DescribeDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainsRequest =
      zio.aws.opensearch.model.DescribeDomainsRequest(domainNames)
    def domainNames: List[DomainName]
    def getDomainNames: ZIO[Any, Nothing, List[DomainName]] =
      ZIO.succeed(domainNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest
  ) extends zio.aws.opensearch.model.DescribeDomainsRequest.ReadOnly {
    override val domainNames: List[DomainName] = impl
      .domainNames()
      .asScala
      .map { item =>
        zio.aws.opensearch.model.primitives.DomainName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest
  ): zio.aws.opensearch.model.DescribeDomainsRequest.ReadOnly = new Wrapper(
    impl
  )
}
