package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{GUID, DomainName}
import scala.jdk.CollectionConverters._
final case class DescribeDomainChangeProgressRequest(
    domainName: DomainName,
    changeId: Optional[GUID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest = {
    import DescribeDomainChangeProgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        changeId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.changeId)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDomainChangeProgressRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainChangeProgressRequest
      .wrap(buildAwsValue())
}
object DescribeDomainChangeProgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.DescribeDomainChangeProgressRequest =
      zio.aws.opensearch.model.DescribeDomainChangeProgressRequest(
        domainName,
        changeId.map(value => value)
      )
    def domainName: DomainName
    def changeId: Optional[GUID]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getChangeId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("changeId", changeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest
  ) extends zio.aws.opensearch.model.DescribeDomainChangeProgressRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val changeId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.changeId())
      .map(value => zio.aws.opensearch.model.primitives.GUID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest
  ): zio.aws.opensearch.model.DescribeDomainChangeProgressRequest.ReadOnly =
    new Wrapper(impl)
}
