package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePackageResponse(
    packageDetails: Optional[zio.aws.opensearch.model.PackageDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DeletePackageResponse = {
    import DeletePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DeletePackageResponse
      .builder()
      .optionallyWith(packageDetails.map(value => value.buildAwsValue()))(
        _.packageDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DeletePackageResponse.ReadOnly =
    zio.aws.opensearch.model.DeletePackageResponse.wrap(buildAwsValue())
}
object DeletePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DeletePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DeletePackageResponse =
      zio.aws.opensearch.model
        .DeletePackageResponse(packageDetails.map(value => value.asEditable))
    def packageDetails
        : Optional[zio.aws.opensearch.model.PackageDetails.ReadOnly]
    def getPackageDetails
        : ZIO[Any, AwsError, zio.aws.opensearch.model.PackageDetails.ReadOnly] =
      AwsError.unwrapOptionField("packageDetails", packageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DeletePackageResponse
  ) extends zio.aws.opensearch.model.DeletePackageResponse.ReadOnly {
    override val packageDetails
        : Optional[zio.aws.opensearch.model.PackageDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageDetails())
        .map(value => zio.aws.opensearch.model.PackageDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DeletePackageResponse
  ): zio.aws.opensearch.model.DeletePackageResponse.ReadOnly = new Wrapper(impl)
}
