package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait AutoTuneDesiredState {
  def unwrap
      : software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState
}
object AutoTuneDesiredState {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState
  ): zio.aws.opensearch.model.AutoTuneDesiredState = value match {
    case software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.AutoTuneDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.opensearch.model.AutoTuneDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState.ENABLED
  }
  case object DISABLED extends zio.aws.opensearch.model.AutoTuneDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState =
      software.amazon.awssdk.services.opensearch.model.AutoTuneDesiredState.DISABLED
  }
}
